/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.extension.http.api.policy.HttpListenerPolicyPointcutParameters;
import org.mule.extension.http.api.policy.HttpRequestPolicyPointcutParameters;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public class PointcutTestUtils {
    private static final ComponentIdentifier INVALID_COMPONENT_IDENTIFIER = ComponentIdentifier.builder().namespace("invalid").name("component").build();
    private static final Optional<String> CONFIG_FILE_NAME = Optional.of("test-flow.xml");

    public static PolicyPointcutParameters listenerPointcutParameters(String flowName) {
        ImmutableMap annotations = ImmutableMap.of();
        return PointcutTestUtils.listenerPointcutParameters(flowName, ".", ".", (Map<QName, Object>)annotations);
    }

    public static PolicyPointcutParameters annotatedListenerPointcutParameters(String flowName) {
        ImmutableMap annotations = ImmutableMap.of((Object)QName.valueOf("{http://www.mulesoft.org/schema/mule/api-gateway}disablePolicies"), (Object)"true");
        return PointcutTestUtils.listenerPointcutParameters(flowName, ".", ".", (Map<QName, Object>)annotations);
    }

    public static PolicyPointcutParameters listenerPointcutParameters(String flowName, String path, String method, Map<QName, Object> annotations) {
        return new HttpListenerPolicyPointcutParameters(PointcutTestUtils.component(flowName, HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER, annotations), path, method);
    }

    public static PolicyPointcutParameters listenerPointcutParameters(String flowName, String path, String method, String maskedPath, MultiMap<String, String> headers, Map<QName, Object> annotations) {
        return new HttpListenerPolicyPointcutParameters(PointcutTestUtils.component(flowName, HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER, annotations), path, method, maskedPath, headers);
    }

    public static PolicyPointcutParameters requesterPointcutParameters(String flowName) {
        ImmutableMap annotations = ImmutableMap.of();
        return PointcutTestUtils.requesterPointcutParameters(flowName, "", "", (Map<QName, Object>)annotations);
    }

    public static PolicyPointcutParameters annotatedRequesterPointcutParameters(String flowName) {
        ImmutableMap annotations = ImmutableMap.of((Object)QName.valueOf("{http://www.mulesoft.org/schema/mule/api-gateway}disablePolicies"), (Object)"true");
        return PointcutTestUtils.requesterPointcutParameters(flowName, "", "", (Map<QName, Object>)annotations);
    }

    public static PolicyPointcutParameters requesterPointcutParameters(String flowName, String path, String method, Map<QName, Object> annotations) {
        return new HttpRequestPolicyPointcutParameters(PointcutTestUtils.component(flowName, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER, annotations), path, method);
    }

    public static PolicyPointcutParameters nonHttpPointcutParameters(String flowName) {
        ImmutableMap annotations = ImmutableMap.of();
        return new PolicyPointcutParameters(PointcutTestUtils.component(flowName, INVALID_COMPONENT_IDENTIFIER, (Map<QName, Object>)annotations));
    }

    public static Component component(String flowName, ComponentIdentifier componentIdentifier, Map<QName, Object> annotations) {
        TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().identifier(componentIdentifier).type(TypedComponentIdentifier.ComponentType.SOURCE).build();
        return PointcutTestUtils.component(new DefaultComponentLocation(Optional.of(flowName), Collections.singletonList(new DefaultComponentLocation.DefaultLocationPart(flowName, Optional.of(typedComponentIdentifier), CONFIG_FILE_NAME, Optional.of(1), Optional.of(0)))), annotations);
    }

    private static Component component(final DefaultComponentLocation componentLocation, final Map<QName, Object> annots) {
        return new Component(){
            Map<QName, Object> annotations;
            {
                this.annotations = annots;
            }

            public Object getAnnotation(QName qName) {
                return this.annotations.get(qName);
            }

            public Map<QName, Object> getAnnotations() {
                return this.annotations;
            }

            public void setAnnotations(Map<QName, Object> map) {
                throw new RuntimeException("We should not be calling this method");
            }

            public ComponentLocation getLocation() {
                return componentLocation;
            }

            public Location getRootContainerLocation() {
                throw new RuntimeException("We should not be calling this method");
            }
        };
    }
}

