/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.PolicyFolders;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStoreFiles;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class DefaultPolicyStoreTestCase
extends AbstractMuleTestCase {
    private static final String VALID_POLICY_CONFIG = "valid XML";
    private static final String UPDATED_VALID_POLICY_CONFIG = "Updated XML";
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    private PolicyDefinition policyDefinition;
    private PolicyStoreFiles fileHandler;
    private PolicyStore store;

    @Before
    public void setUp() {
        this.store = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        this.fileHandler = new PolicyStoreFiles(PolicyFolders.getPoliciesFolder());
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(PolicyTestValuesConstants.CONFIG_DATA);
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.RESOURCE_POINTCUTS, 1, policyConfiguration);
    }

    @Test
    public void validPolicyCorrectlyStored() throws IOException {
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        File policyFolder = this.fileHandler.getPolicyFolder(this.policyDefinition.getName());
        File policyConfigXml = new File(policyFolder, "policy.xml");
        File policyDefinitionJson = new File(policyFolder, "policy-definition.json");
        Assert.assertThat((Object)this.fileHandler.listPolicyFolders(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertTrue((boolean)policyFolder.exists());
        Assert.assertTrue((boolean)policyConfigXml.exists());
        Assert.assertTrue((boolean)policyDefinitionJson.exists());
        Assert.assertEquals((Object)VALID_POLICY_CONFIG, (Object)FileUtils.readFileToString((File)policyConfigXml));
        Assert.assertEquals((Object)IOUtils.getResourceAsString((String)"json/full-definition.json", ((Object)((Object)this)).getClass()).trim(), (Object)FileUtils.readFileToString((File)policyDefinitionJson).trim());
    }

    @Test
    public void containsValidPolicy() {
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        boolean contains = this.store.contains(this.policyDefinition.getName());
        Assert.assertTrue((boolean)contains);
    }

    @Test
    public void validPolicyCorrectlyDeleted() {
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        this.store.remove(this.policyDefinition.getName());
        File policyFolder = this.fileHandler.getPolicyFolder(this.policyDefinition.getName());
        File policyConfigXml = new File(policyFolder, "policy.xml");
        File policyDefinitionJson = new File(policyFolder, "policy-definition.json");
        Assert.assertThat((Object)this.fileHandler.listPolicyFolders(), (Matcher)Matchers.empty());
        Assert.assertFalse((boolean)policyFolder.exists());
        Assert.assertFalse((boolean)policyConfigXml.exists());
        Assert.assertFalse((boolean)policyDefinitionJson.exists());
    }

    @Test
    public void validPolicyCorrectlyUpdated() throws IOException {
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        PolicyDefinition updatedPolicyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 2, new PolicyConfiguration(null));
        this.store.store(new Policy(null, updatedPolicyDefinition, UPDATED_VALID_POLICY_CONFIG));
        File policyFolder = this.fileHandler.getPolicyFolder(this.policyDefinition.getName());
        File policyConfigXml = new File(policyFolder, "policy.xml");
        File policyDefinitionJson = new File(policyFolder, "policy-definition.json");
        Assert.assertThat((Object)this.fileHandler.listPolicyFolders(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertTrue((boolean)policyFolder.exists());
        Assert.assertTrue((boolean)policyConfigXml.exists());
        Assert.assertTrue((boolean)policyDefinitionJson.exists());
        Assert.assertEquals((Object)UPDATED_VALID_POLICY_CONFIG, (Object)FileUtils.readFileToString((File)policyConfigXml));
        Assert.assertEquals((Object)IOUtils.getResourceAsString((String)"json/updated-definition.json", ((Object)((Object)this)).getClass()).trim(), (Object)FileUtils.readFileToString((File)policyDefinitionJson).trim());
    }

    @Test
    public void storeDeploymentFailures() {
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY, (Exception)new RuntimeException("My message exception"));
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY_2, (Exception)new RuntimeException("My message exception"));
        List fileNames = this.fileHandler.listPolicyDeploymentFailures().stream().map(File::getName).collect(Collectors.toList());
        Assert.assertThat(fileNames, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(fileNames, (Matcher)Matchers.hasItems((Object[])new String[]{"policyTemplate-policyId@1.log", "policyTemplate-policyId@2.log"}));
    }

    @Test
    public void cleanDeploymentFailures() {
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY, (Exception)new RuntimeException("My message exception"));
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY_2, (Exception)new RuntimeException("My message exception"));
        this.store.cleanDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)this.fileHandler.listPolicyDeploymentFailures(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((File)this.fileHandler.listPolicyDeploymentFailures().get(0)).getName(), (Matcher)Is.is((Object)"policyTemplate-policyId@2.log"));
    }

    @Test
    public void cleanDeploymentFailuresDeletesFolder() {
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY, (Exception)new RuntimeException("My message exception"));
        this.store.cleanDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)this.fileHandler.getFailedPoliciesFolder().exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void cleanMultipleDeploymentFailures() {
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY, (Exception)new RuntimeException("My message exception"));
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY_2, (Exception)new RuntimeException("My message exception"));
        this.store.cleanDeploymentFailures(this.policyDefinition.getName());
        Assert.assertThat((Object)this.fileHandler.getFailedPoliciesFolder().exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void deleteRemovesFailures() {
        this.store.storeDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY, (Exception)new RuntimeException("My message exception"));
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        this.store.remove(this.policyDefinition.getName());
        Assert.assertThat((Object)this.fileHandler.listPolicyFolders(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)this.fileHandler.getFailedPoliciesFolder().exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void loadAll() {
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId-2", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 2, new PolicyConfiguration(null));
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        this.store.store(new Policy(null, policyDefinition2, VALID_POLICY_CONFIG));
        List allPolicies = this.store.load();
        Assert.assertThat((Object)allPolicies, (Matcher)Matchers.hasSize((int)2));
        Assert.assertTrue((boolean)allPolicies.contains(this.policyDefinition));
        Assert.assertTrue((boolean)allPolicies.contains(policyDefinition2));
    }

    @Test
    public void onlinePolicies() {
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId-2", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(null));
        OfflinePolicyDefinition offlinePolicy = new OfflinePolicyDefinition("policyId-3", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(null));
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        this.store.store(new Policy(null, policyDefinition2, VALID_POLICY_CONFIG));
        this.store.store(new Policy(null, (PolicyDefinition)offlinePolicy, VALID_POLICY_CONFIG));
        List onlinePolicies = this.store.onlinePolicies();
        Assert.assertThat((Object)onlinePolicies, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)onlinePolicies, (Matcher)Matchers.hasItems((Object[])new PolicyDefinition[]{this.policyDefinition, policyDefinition2}));
    }

    @Test
    public void offlinePolicies() throws URISyntaxException, IOException {
        this.store.store(new Policy(null, this.policyDefinition, VALID_POLICY_CONFIG));
        FileUtils.copyFileToDirectory((File)this.definitionFile(), (File)PolicyFolders.getOfflinePoliciesFolder());
        FileUtils.copyFileToDirectory((File)this.anotherDefinitionFile(), (File)PolicyFolders.getOfflinePoliciesFolder());
        FileUtils.copyFileToDirectory((File)this.invalidDefinitionFile(), (File)PolicyFolders.getOfflinePoliciesFolder());
        List offlinePolicies = this.store.offlinePolicies();
        List policyNames = offlinePolicies.stream().map(PolicyDefinition::getName).collect(Collectors.toList());
        Assert.assertThat((Object)offlinePolicies, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(policyNames, (Matcher)Matchers.hasItems((Object[])new String[]{"offline-multiple-apis-definition", "offline-single-api-definition"}));
    }

    private File definitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/offline-single-api-definition.json").toURI());
    }

    private File anotherDefinitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/offline-multiple-apis-definition.json").toURI());
    }

    private File invalidDefinitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/offline-invalid-field-definition.json").toURI());
    }
}

