/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EncryptedPropertiesSerializerTestCase
extends AbstractMuleTestCase {
    private static final String STRING_PROPERTY = "String";
    private static final String STRINGS_PROPERTY = "Strings";
    private static final String KEYVALUE_PROPERTY = "Keyvalue";
    private static final String KEYVALUES_PROPERTY = "Keyvalues";
    private static final String KEY = "someKey";
    private static final String KEY_2 = "anotherKey";
    private static final String VALUE = "someValue";
    private static final String VALUE_2 = "anotherValue";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private EncryptedPropertiesSerializer serializer;
    private File destFolder;

    @Before
    public void setUp() throws IOException {
        this.serializer = new EncryptedPropertiesSerializer();
        this.destFolder = this.temporaryFolder.newFolder();
    }

    @Test
    public void serializeWhenSmartEncryption() throws IOException, URISyntaxException {
        this.serializer.store(this.configData(), this.destFolder);
        File expected = new File(((Object)((Object)this)).getClass().getResource("/properties/properties.yaml").toURI());
        Assert.assertThat((Object)FileUtils.readFileToString((File)this.yaml()), (Matcher)Is.is((Object)FileUtils.readFileToString((File)expected)));
    }

    @Test
    public void serializeWhenNoConfigData() throws IOException {
        this.serializer.store(Collections.emptyMap(), this.destFolder);
        Assert.assertThat((Object)this.yaml().exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void serializeWhenNoConfigDataAndExistentFileIsDeleted() throws IOException {
        this.serializer.store(this.configData(), this.destFolder);
        this.serializer.store(Collections.emptyMap(), this.destFolder);
        Assert.assertThat((Object)this.yaml().exists(), (Matcher)Is.is((Object)false));
    }

    private Map<String, Object> configData() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("key", KEY);
        propertyMap.put("value", VALUE);
        HashMap<String, String> propertyMap2 = new HashMap<String, String>();
        propertyMap2.put("key", KEY_2);
        propertyMap2.put("value", VALUE_2);
        HashMap<String, Object> configData = new HashMap<String, Object>();
        configData.put(STRING_PROPERTY, VALUE);
        configData.put(STRINGS_PROPERTY, Arrays.asList(VALUE, VALUE_2));
        configData.put(KEYVALUE_PROPERTY, propertyMap);
        configData.put(KEYVALUES_PROPERTY, Arrays.asList(propertyMap, propertyMap2));
        return configData;
    }

    private File yaml() {
        return new File(this.destFolder, "encrypted-properties.yaml");
    }
}

