/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.policies.deployment.InternalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.FlexibleGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.StrictGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.template.provider.ClasspathPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateDescriptorFactory;
import org.slf4j.Logger;

public class GateKeeperSupplier
implements Supplier<Optional<GateKeeper>> {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(GateKeeper.class);
    private final GateKeeperConfiguration configuration;
    private final ApiService apiService;
    private final PolicyFactory policyFactory;

    public GateKeeperSupplier(GateKeeperConfiguration configuration, ApiService apiService) {
        this.configuration = configuration;
        this.apiService = apiService;
        this.policyFactory = new DefaultPolicyFactory(new HandlebarsPolicyTemplateResolver(), new ClasspathPolicyTemplateProvider(new PolicyTemplateDescriptorFactory()));
    }

    @Override
    public Optional<GateKeeper> get() {
        Optional<GateKeeper> gateKeeper = Optional.empty();
        GateKeeperConfiguration.Mode gateKeeperMode = this.configuration.mode();
        if (this.configuration.isEnabled()) {
            LOGGER.info("GateKeeper started in {} mode", (Object)gateKeeperMode);
            InternalPolicyDeployer policyDeployer = new InternalPolicyDeployer(this.policyFactory);
            gateKeeper = Optional.of(this.configuration.mode().equals((Object)GateKeeperConfiguration.Mode.STRICT) ? new StrictGateKeeper(this.apiService, policyDeployer) : new FlexibleGateKeeper(this.apiService, policyDeployer));
        } else {
            LOGGER.info("GateKeeper is disabled.");
        }
        return gateKeeper;
    }
}

