/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import com.google.common.base.Preconditions;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateDescriptorFactory;

public class ClasspathPolicyTemplateProvider
extends PolicyTemplateProvider {
    public static final String POLICY_TEMPLATE_FILE_NAME_PATTERN = "%s-mule-policy.jar";
    private final ClassLoader classLoader;

    public ClasspathPolicyTemplateProvider(PolicyTemplateDescriptorFactory templateDescriptorFactory) {
        super(templateDescriptorFactory);
        this.classLoader = this.getClass().getClassLoader();
    }

    public ClasspathPolicyTemplateProvider(PolicyTemplateDescriptorFactory templateDescriptorFactory, ClassLoader classLoader) {
        super(templateDescriptorFactory);
        this.classLoader = classLoader;
    }

    @Override
    protected PolicyTemplateAssets getPolicyTemplateAssets(PolicyTemplateKey templateKey) throws IOException {
        File templateJarFile = this.getFileAsResource(templateKey, String.format(POLICY_TEMPLATE_FILE_NAME_PATTERN, templateKey.getAssetId()));
        return new PolicyTemplateAssets(templateJarFile);
    }

    private File getFileAsResource(PolicyTemplateKey templateKey, String resource) throws IOException {
        InputStream resourceStream = this.classLoader.getResourceAsStream(resource);
        Preconditions.checkState((resourceStream != null ? 1 : 0) != 0, (Object)String.format("Could not find policy template asset %s for %s", resource, templateKey.getAssetId()));
        File targetFile = new File(this.templatesTempFolder, resource);
        FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
        return targetFile;
    }
}

