/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.mulesoft.mule.runtime.gw.api.annotations.GatewayAppAnnotations;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.core.internal.util.OneTimeWarning;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsHttpComponentPointcut
implements PolicyPointcut {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsHttpComponentPointcut.class);
    private final OneTimeWarning notApplicableWarn = new OneTimeWarning(LOGGER, "{} is annotated with 'api-gateway:disablePolicies', no operation block policies will be applied to this element.");
    private final String policyName;

    public IsHttpComponentPointcut(String policyName) {
        this.policyName = policyName;
    }

    public boolean matches(PolicyPointcutParameters policyPointcutParameters) {
        boolean matches;
        ComponentIdentifier componentIdentifier = policyPointcutParameters.getComponent().getLocation().getComponentIdentifier().getIdentifier();
        boolean isRequester = HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER.equals(componentIdentifier);
        boolean bl = matches = isRequester || HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER.equals(componentIdentifier);
        if (this.isAnnotated(policyPointcutParameters)) {
            if (isRequester) {
                this.notApplicableWarn.warn(new Object[]{componentIdentifier});
                LOGGER.trace("{} does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'. No policies will be applied to this operation.", (Object)componentIdentifier);
                matches = false;
            } else {
                LOGGER.trace("Annotation 'api-gateway:disablePolicies' has no effect on component {}", (Object)componentIdentifier);
            }
        }
        if (matches) {
            LOGGER.trace("Request matches pointcut of policy {} since {} is a valid HTTP component.", (Object)this.policyName, (Object)componentIdentifier);
        } else {
            LOGGER.trace("Request does not match pointcut of policy {} since {} is not a valid HTTP component.", (Object)this.policyName, (Object)componentIdentifier);
        }
        return matches;
    }

    private boolean isAnnotated(PolicyPointcutParameters policyPointcutParameters) {
        String annotation = (String)policyPointcutParameters.getComponent().getAnnotation(GatewayAppAnnotations.DISABLE_POLICIES_ANNOTATION);
        return annotation != null && annotation.equals("true");
    }
}

