/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyTemplateDto;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateDescriptorFactory;

public class FileSystemPolicyTemplateProvider
extends PolicyTemplateProvider {
    public static final String POLICY_TEMPLATE_PATTERN = "%s-mule-policy.jar";
    public static final String POLICY_TEMPLATE_LIGHT_PATTERN = "%s-mule-policy-light-package.jar";
    public static final String POLICY_YAML_PATTERN = "%s.yaml";
    private final File templatesFolder;
    private final ApiPlatformClient restClient;

    public FileSystemPolicyTemplateProvider(ApiPlatformClient restClient, PolicyTemplateDescriptorFactory templateDescriptorFactory) {
        super(templateDescriptorFactory);
        this.restClient = restClient;
        this.templatesFolder = PolicyFolders.getPolicyTemplatesFolder();
    }

    @Override
    protected PolicyTemplateAssets getPolicyTemplateAssets(PolicyTemplateKey templateKey) {
        PolicyTemplateAssets policyTemplateAssets = this.getTemplateFiles(templateKey);
        Preconditions.checkState((boolean)policyTemplateAssets.getTemplateJarFile().exists(), (String)("Could not find policy Jar template " + templateKey.getName()));
        return policyTemplateAssets;
    }

    private PolicyTemplateAssets getTemplateFiles(PolicyTemplateKey templateKey) {
        File templateFile = new File(this.templatesFolder, String.format(POLICY_TEMPLATE_PATTERN, templateKey.getName()));
        File lightTemplateFile = new File(this.templatesFolder, String.format(POLICY_TEMPLATE_LIGHT_PATTERN, templateKey.getName()));
        File yamlSpecFile = new File(this.templatesFolder, String.format(POLICY_YAML_PATTERN, templateKey.getName()));
        if (!templateFile.exists() && !lightTemplateFile.exists()) {
            PolicyTemplateDto template;
            LOGGER.debug("Policy template {} assets are not present in the runtime. Fetching metadata for assets...", (Object)templateKey);
            try {
                template = this.restClient.getPolicyTemplateMetadata(templateKey);
            }
            catch (Exception e) {
                throw new PolicyTemplateAssetException("Unexpected error when requesting template metadata for policy " + templateKey.getName(), e);
            }
            templateFile = this.downloadFile(templateKey, template.getJarDownloadLink(), templateFile, true);
            yamlSpecFile = this.downloadFile(templateKey, template.getYamlDownloadLink(), yamlSpecFile, false);
            return new PolicyTemplateAssets(templateFile, yamlSpecFile);
        }
        return new PolicyTemplateAssets(templateFile.exists() ? templateFile : lightTemplateFile, yamlSpecFile);
    }

    private File downloadFile(PolicyTemplateKey templateKey, String link, File targetFile, boolean retry) {
        block2: {
            LOGGER.debug("Starting download of policy template asset {}", (Object)templateKey);
            try {
                InputStream inputStream = this.restClient.downloadTemplateAsset(link);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                LOGGER.debug("Policy template {} successfully downloaded", (Object)templateKey);
            }
            catch (Exception e) {
                LOGGER.debug("Unable to save file {} from link {} ", (Object)targetFile.getName(), (Object)link);
                if (!retry) break block2;
                throw new PolicyTemplateAssetException("Unexpected error trying to download policy template asset" + templateKey.getName(), e);
            }
        }
        return targetFile;
    }
}

