/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedPolicyException;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactoryTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;

public class DefaultPolicyFactory
extends PolicyFactoryTemplate {
    public DefaultPolicyFactory(PolicyTemplateResolver templateResolver, PolicyTemplateProvider templateProvider) {
        super(templateResolver, templateProvider);
    }

    @Override
    public Policy createFromPolicyDefinition(PolicyDefinition policyDefinition) {
        if (policyDefinition.getConfigurationData().isEncrypted()) {
            throw new EncryptedPolicyException();
        }
        PolicyTemplate policyTemplate = this.getPolicyTemplate(policyDefinition);
        policyDefinition = this.evaluatePolicyIdentityManagement(policyDefinition, policyTemplate);
        String resolvedTemplate = this.resolveTemplate(policyTemplate, policyDefinition.getConfigurationData().getConfiguration());
        return new Policy(policyTemplate, policyDefinition, resolvedTemplate);
    }
}

