/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.UnresolvedPolicyException;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateException;
import java.util.Optional;
import org.slf4j.Logger;

public class DefaultTransactionalPolicyDeploymentService
implements TransactionalPolicyDeploymentService {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultTransactionalPolicyDeploymentService.class);
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final PolicyStore policyStore;
    private final PolicyDeployer policyDeployer;
    private final PolicyFactory policyFactory;

    public DefaultTransactionalPolicyDeploymentService(PolicyDeploymentTracker policyDeploymentTracker, PolicyStore policyStore, PolicyFactory policyFactory, PolicyDeployer policyDeployer) {
        this.policyDeployer = policyDeployer;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyStore = policyStore;
        this.policyFactory = policyFactory;
    }

    @Override
    public void deploy(PolicyDefinition policyDefinition, Api api) {
        try {
            PolicyDefinitionDeploymentStatus status = this.policyDeployer.deploy(this.resolvePolicy(policyDefinition), api);
            if (status.isDeploymentSuccess()) {
                this.informSuccessfullyDeploy(status, api);
            } else {
                this.informDeploymentFailure(new PolicyDeploymentStatus(status, Optional.empty()), api);
            }
        }
        catch (UnresolvedPolicyException e) {
            this.templateFailed(e, api);
        }
    }

    @Override
    public void updateOrder(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api) {
        try {
            PolicyDefinitionDeploymentStatus status = this.policyDeployer.updateOrder(this.resolvePolicy(updatedPolicy), api);
            if (status.isDeploymentSuccess()) {
                this.informSuccessfullyDeploy(status, api);
            } else {
                LOGGER.info("Hot Reorder Failed for policy {} in app {}, unapplying and reapplying policy to change the order.", (Object)updatedPolicy.getName(), (Object)api.getImplementation().getArtifactName());
                this.update(oldPolicy, updatedPolicy, api);
            }
        }
        catch (UnresolvedPolicyException e) {
            this.templateFailed(e, api);
        }
    }

    @Override
    public void update(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api) {
        block6: {
            try {
                Policy policy = this.resolvePolicy(updatedPolicy);
                this.undeploy(oldPolicy, api);
                PolicyDefinitionDeploymentStatus status = this.policyDeployer.deploy(policy, api);
                if (status.isDeploymentSuccess()) {
                    this.informSuccessfullyDeploy(status, api);
                    break block6;
                }
                this.undeploy(updatedPolicy, api);
                try {
                    PolicyDefinitionDeploymentStatus revertStatus = this.policyDeployer.deploy(this.resolvePolicy(oldPolicy), api);
                    if (revertStatus.isDeploymentSuccess()) {
                        LOGGER.info("Successfully reverted {} in app {} to previous configuration.", (Object)oldPolicy.getName(), (Object)api.getImplementation().getArtifactName());
                        this.informDeploymentFailure(new PolicyDeploymentStatus(status, Optional.of(revertStatus)), api);
                        break block6;
                    }
                    LOGGER.error("Failed to revert {} in app {} to previous configuration, api will remain unprotected.", (Object)oldPolicy.getName(), (Object)api.getImplementation().getArtifactName());
                    this.informDeploymentFailure(new PolicyDeploymentStatus(status, Optional.empty()), api);
                }
                catch (UnresolvedPolicyException e) {
                    this.templateFailed(e, api);
                }
            }
            catch (UnresolvedPolicyException e) {
                this.templateFailed(e, api);
                LOGGER.info("Error preemptively caught for update of policy {} in app {}. Previous policy configuration will remain applied.", (Object)updatedPolicy.getName(), (Object)api.getImplementation().getArtifactName());
            }
        }
    }

    @Override
    public void revertPolicy(PolicyDefinition policy, Api api) {
        LOGGER.info("The currently applied policy configuration for {} in app {} has become the target configuration configuration.", (Object)policy.getName(), (Object)api.getImplementation().getArtifactName());
        this.informSuccessfullyDeploy(new PolicyDefinitionDeploymentStatus(policy), api);
    }

    @Override
    public void undeploy(PolicyDefinition policy, Api api) {
        this.policyDeployer.undeploy(policy.getName(), api);
        this.policyDeploymentTracker.policyRemoved(api.getKey(), policy.getId());
        if (!this.policyDeploymentTracker.policyHasDeployments(policy.getId())) {
            this.policyStore.remove(policy.getName());
        }
    }

    private Policy resolvePolicy(PolicyDefinition policyDefinition) throws UnresolvedPolicyException {
        try {
            return this.policyFactory.createFromPolicyDefinition(policyDefinition);
        }
        catch (PolicyTemplateException e) {
            throw new UnresolvedPolicyException(new PolicyDefinitionDeploymentStatus(policyDefinition, e.status(), e));
        }
        catch (Exception e) {
            throw new UnresolvedPolicyException(new PolicyDefinitionDeploymentStatus(policyDefinition, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED, e));
        }
    }

    private void templateFailed(UnresolvedPolicyException e, Api api) {
        PolicyDefinitionDeploymentStatus latestStatus = e.getStatus();
        String policyName = latestStatus.getPolicyDefinition().getName();
        String appName = api.getImplementation().getArtifactName();
        LOGGER.error("Error deploying policy " + policyName + " to application " + appName, (Throwable)e);
        Optional<PolicyDefinitionDeploymentStatus> appliedStatus = this.policyDeploymentTracker.policyStatus(api.getKey(), latestStatus.getPolicyDefinition().getId()).flatMap(PolicyDeploymentStatus::getAppliedPolicyStatus);
        this.informDeploymentFailure(new PolicyDeploymentStatus(latestStatus, appliedStatus), api);
    }

    private void informSuccessfullyDeploy(PolicyDefinitionDeploymentStatus status, Api api) {
        this.policyDeploymentTracker.policyRemoved(api.getImplementation().getApiKey(), status.getPolicyDefinition().getId());
        this.policyDeploymentTracker.policyDeployed(api.getImplementation().getApiKey(), new PolicyDeploymentStatus(status));
        this.policyStore.cleanDeploymentFailure(status.getPolicyDefinition(), api.getKey());
    }

    private void informDeploymentFailure(PolicyDeploymentStatus status, Api api) {
        this.policyDeploymentTracker.policyRemoved(api.getImplementation().getApiKey(), status.getLatestPolicyStatus().getPolicyDefinition().getId());
        this.policyDeploymentTracker.policyDeployed(api.getImplementation().getApiKey(), status);
        this.policyStore.store(status.getAppliedPolicyStatus().orElseGet(status::getLatestPolicyStatus).getPolicyDefinition());
        this.policyStore.storeDeploymentFailure(status.getLatestPolicyStatus().getPolicyDefinition(), api.getKey(), status.getLatestPolicyStatus().getException());
    }
}

