/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.FlexibleGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.StrictGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.service.InternalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.provider.ClasspathPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.provider.GatewayPolicyTemplateDescriptorFactory;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class GateKeeperSupplier
implements Supplier<Optional<GateKeeper>> {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(GateKeeper.class);
    private final GateKeeperConfiguration configuration;
    private final ApiService apiService;
    private final PolicyFactory policyFactory;

    public GateKeeperSupplier(GateKeeperConfiguration configuration, ApiService apiService) {
        this.configuration = configuration;
        this.apiService = apiService;
        this.policyFactory = new DefaultPolicyFactory(new HandlebarsPolicyTemplateResolver(), new ClasspathPolicyTemplateProvider(new GatewayPolicyTemplateDescriptorFactory(), new PolicyTemplateStore()));
    }

    @Override
    public Optional<GateKeeper> get() {
        Optional<GateKeeper> gateKeeper = Optional.empty();
        GateKeeperConfiguration.Mode gateKeeperMode = this.configuration.mode();
        if (this.configuration.isEnabled()) {
            LOGGER.info("GateKeeper started in {} mode", (Object)gateKeeperMode);
            InternalPolicyDeploymentService policyDeployer = new InternalPolicyDeploymentService(this.policyFactory);
            boolean blockFailedRevert = this.configuration.blockFailedRevert();
            gateKeeper = Optional.of(this.configuration.mode().equals((Object)GateKeeperConfiguration.Mode.STRICT) ? new StrictGateKeeper(this.apiService, policyDeployer, blockFailedRevert) : new FlexibleGateKeeper(this.apiService, policyDeployer, blockFailedRevert));
        } else {
            LOGGER.info("GateKeeper is disabled.");
        }
        return gateKeeper;
    }
}

