/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.SplitModelPolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateException;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.slf4j.Logger;

public class DefaultPolicyDeployer
implements PolicyDeployer {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultPolicyDeployer.class);
    private final PolicyStore policyStore;
    private final PolicyNotificationListenerSuppliers notificationListenerManager;
    private final PolicyParametrizationFactory policyParametrizationFactory;

    public DefaultPolicyDeployer(PolicyStore policyStore, PolicyNotificationListenerSuppliers notificationListenerManager, PolicyParametrizationFactory policyParametrizationFactory) {
        this.policyParametrizationFactory = policyParametrizationFactory;
        this.policyStore = policyStore;
        this.notificationListenerManager = notificationListenerManager;
    }

    @Override
    public PolicyDefinitionDeploymentStatus deploy(Policy policy, Api api) {
        return this.internalDeploy(policy, false, api);
    }

    @Override
    public PolicyDefinitionDeploymentStatus updateOrder(Policy policy, Api api) {
        return this.internalDeploy(policy, true, api);
    }

    @Override
    public boolean undeploy(String policyName, Api api) {
        String parametrizationId;
        ApiImplementation implementation = api.getImplementation();
        boolean removed = implementation.removePolicy(parametrizationId = this.policyParametrizationFactory.buildParametrizationId(policyName, implementation));
        if (removed) {
            LOGGER.info("Policy {} un-applied from {} in application {}", new Object[]{policyName, api, implementation.getArtifactName()});
        }
        return removed;
    }

    private PolicyDefinitionDeploymentStatus internalDeploy(Policy policy, boolean isPolicyReorder, Api api) {
        PolicyDefinition policyDefinition = policy.getPolicyDefinition();
        try {
            policyDefinition = policy.getPolicyDefinition();
            ApiImplementation implementation = api.getImplementation();
            this.logApplyingPolicy(policyDefinition, api, implementation);
            implementation.addPolicy(policy.getPolicyTemplate().getTemplateDescriptor(), this.policyParametrization(policy, api, isPolicyReorder));
            this.logAppliedPolicy(policyDefinition, api, implementation);
            return new PolicyDefinitionDeploymentStatus(policyDefinition);
        }
        catch (PolicyTemplateException e) {
            return this.handleDeployException(policyDefinition, api, e.status(), e);
        }
        catch (Exception e) {
            return this.handleDeployException(policyDefinition, api, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED, e);
        }
    }

    private PolicyDefinitionDeploymentStatus handleDeployException(PolicyDefinition policyDefinition, Api api, PolicyDefinitionDeploymentStatus.DeploymentStatus status, Exception e) {
        this.logDeploymentError(policyDefinition.getName(), api.getImplementation().getArtifactName(), e);
        return new PolicyDefinitionDeploymentStatus(policyDefinition, status, e);
    }

    private PolicyParametrization policyParametrization(Policy policy, Api api, boolean isPolicyReorder) {
        PolicyDefinition policyDefinition = policy.getPolicyDefinition();
        ApiImplementation implementation = api.getImplementation();
        this.policyStore.store(policy);
        return this.policyParametrizationFactory.create(policyDefinition, implementation, this.policyStore.getPolicyConfigFile(policyDefinition.getName()), this.policyStore.getEncryptedPropertiesFile(policyDefinition.getName()), isPolicyReorder, this.notificationListenerManager.supply(implementation, policyDefinition, policy.getPolicyTemplate().getPolicySpecification()));
    }

    private void logApplyingPolicy(PolicyDefinition policyDefinition, Api api, ApiImplementation implementation) {
        SplitModelPolicyTemplateKey key = SplitModelPolicyTemplateKey.fromExchangeKey((PolicyTemplateKey)policyDefinition.getTemplateKey());
        LOGGER.debug("Applying policy {} {} to {} in application {}", new Object[]{policyDefinition.getName(), key.versionInfo(), api, implementation.getArtifactName()});
    }

    private void logAppliedPolicy(PolicyDefinition policyDefinition, Api api, ApiImplementation implementation) {
        SplitModelPolicyTemplateKey key = SplitModelPolicyTemplateKey.fromExchangeKey((PolicyTemplateKey)policyDefinition.getTemplateKey());
        LOGGER.info("Applied policy {} {} to {} in application {}", new Object[]{policyDefinition.getName(), key.versionInfo(), api, implementation.getArtifactName()});
    }

    private void logDeploymentError(String policyName, String appName, Exception e) {
        LOGGER.error("Error deploying policy " + policyName + " to application " + appName, (Throwable)e);
    }
}

