/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdpApisHealthCheckListener
extends GateKeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdpApisHealthCheckListener.class);

    public HdpApisHealthCheckListener(ApiService apiService) {
        super(apiService);
    }

    @Override
    protected boolean validOrigin(PolicySet set) {
        return true;
    }

    @Override
    protected boolean isMonitored(Api api) {
        return api.getImplementation().isHdp();
    }

    @Override
    protected void blockApi(Api api) {
        api.getImplementation().gatekeeperStatus().blocked();
    }

    @Override
    protected void unblockApi(Api api) {
        LOGGER.info("Api policy set deployment on hdp complete, unblocking api: {}", (Object)api.getKey().toString());
        api.getImplementation().gatekeeperStatus().unblocked();
    }
}

