/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.slf4j.Logger;

public abstract class BlockingGateKeeper
extends GateKeeper {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(BlockingGateKeeper.class);
    private static final PolicyTemplateKey GATEKEEPER_POLICY_TEMPLATE_KEY = new PolicyTemplateKey("com.mulesoft.anypoint", "mule-gatekeeper-policy-template", MuleManifest.getProductVersion());
    private static final String GATEKEEPER_POLICY_ID = "gatekeeper";
    private final TransactionalPolicyDeploymentService policyDeployer;
    private final boolean blockFailedRevert;

    public BlockingGateKeeper(ApiService apiService, TransactionalPolicyDeploymentService policyDeployer, boolean blockFailedRevert) {
        super(apiService);
        this.policyDeployer = policyDeployer;
        this.blockFailedRevert = blockFailedRevert;
    }

    @Override
    public void onPoliciesRemoved(ApiKey apiKey) {
        this.getMonitoredApi(apiKey).ifPresent(this::doBlockApi);
    }

    @Override
    protected boolean isMonitored(Api api) {
        return !api.getImplementation().isHdp();
    }

    @Override
    public void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet, List<PolicyDefinitionDeploymentStatus> deploymentStatuses) {
        this.checkRevertFailed(apiKey, deploymentStatuses);
        super.onPolicySetDeploymentCompleted(apiKey, policySet, deploymentStatuses);
    }

    protected void checkRevertFailed(ApiKey apiKey, List<PolicyDefinitionDeploymentStatus> deploymentStatuses) {
        this.apiService.get(apiKey).ifPresent(api -> {
            if (this.isMonitored((Api)api) && this.blockFailedRevert && this.hasFailedReverts(deploymentStatuses)) {
                this.doBlockApi((Api)api);
            }
        });
    }

    protected boolean hasFailedReverts(List<PolicyDefinitionDeploymentStatus> deploymentStatuses) {
        return deploymentStatuses.stream().anyMatch(PolicyDefinitionDeploymentStatus::isRevertFailed);
    }

    @Override
    protected void blockApi(Api api) {
        MuleContext context = api.getImplementation().getFlow().getMuleContext();
        context.getNotificationManager().addListener((NotificationListener)new GateKeeperMuleContextListener(api, this));
    }

    protected void doBlockApi(Api api) {
        ApiImplementation implementation = api.getImplementation();
        GatekeeperStatusTracker gatekeeperStatus = implementation.gatekeeperStatus();
        if (!gatekeeperStatus.isBlocked()) {
            PolicyDefinition policyDefinition = this.gatekeeperPolicyDefinition(api);
            this.policyDeployer.deploy(policyDefinition, api);
            gatekeeperStatus.blocked();
            LOGGER.info("API {} is blocked (unavailable).", (Object)implementation.getApiKey());
        }
    }

    @Override
    protected void unblockApi(Api api) {
        ApiImplementation implementation = api.getImplementation();
        this.policyDeployer.undeploy(this.gatekeeperPolicyDefinition(api), api);
        implementation.gatekeeperStatus().unblocked();
        LOGGER.info("API {} is now unblocked (available).", (Object)implementation.getApiKey());
    }

    private PolicyDefinition gatekeeperPolicyDefinition(Api api) {
        ApiImplementation implementation = api.getImplementation();
        return new OfflinePolicyDefinition(this.getPolicyId(api), GATEKEEPER_POLICY_TEMPLATE_KEY, implementation.getApiKey(), new ArrayList<HttpResourcePointcut>(), 1, new PolicyConfiguration(Collections.emptyMap()));
    }

    private String getPolicyId(Api api) {
        return "gatekeeper-" + api.getKey().id();
    }

    public static class GateKeeperMuleContextListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        private final Api api;
        private final BlockingGateKeeper gateKeeper;

        public GateKeeperMuleContextListener(Api api, BlockingGateKeeper gateKeeper) {
            this.api = api;
            this.gateKeeper = gateKeeper;
        }

        public void onNotification(MuleContextNotification notification) {
            if (this.isMuleContextStarting(notification)) {
                this.gateKeeper.doBlockApi(this.api);
            } else if (this.isMuleContextStarted(notification)) {
                this.api.getImplementation().getFlow().getMuleContext().getNotificationManager().removeListener((NotificationListener)this);
            }
        }

        private boolean isMuleContextStarting(MuleContextNotification notification) {
            return 103 == notification.getAction().getActionId();
        }

        private boolean isMuleContextStarted(MuleContextNotification notification) {
            return 104 == notification.getAction().getActionId();
        }
    }
}

