/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicyDefinitionSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStoreFiles;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class DefaultPolicyStore
implements PolicyStore {
    public static final String POLICY_DEFINITION_JSON_FILE_NAME = "policy-definition.json";
    public static final String POLICY_CONFIG_XML_FILE_NAME = "policy.xml";
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultPolicyStore.class);
    private final PolicyStoreFiles storeFiles;
    private PolicyDefinitionSerializer policyDefinitionSerializer = new PolicyDefinitionSerializer();
    private EncryptedPropertiesSerializer encryptedPropertiesSerializer;

    public DefaultPolicyStore(EncryptedPropertiesSerializer encryptedPropertiesSerializer) {
        this.storeFiles = new PolicyStoreFiles(PolicyFolders.getPoliciesFolder());
        this.encryptedPropertiesSerializer = encryptedPropertiesSerializer;
    }

    @Override
    public List<PolicyDefinition> load() {
        return this.loadPolicyDefinitions(this.storeFiles.listPolicyFolders());
    }

    @Override
    public List<PolicyDefinition> onlinePolicies() {
        return this.load().stream().filter(PolicyDefinition::isOnline).collect(Collectors.toList());
    }

    @Override
    public List<PolicyDefinition> offlinePolicies() {
        return this.storeFiles.listOfflinePoliciesDescriptors().stream().map(file -> {
            try {
                return this.policyDefinitionSerializer.deserializeOfflineFromFile((File)file);
            }
            catch (OfflinePolicyDeserializationException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean contains(String policyName) {
        return this.storeFiles.getPolicyFolder(policyName).exists();
    }

    @Override
    public File getPolicyConfigFile(String policyName) {
        return new File(this.storeFiles.getPolicyFolder(policyName), POLICY_CONFIG_XML_FILE_NAME);
    }

    @Override
    public File getEncryptedPropertiesFile(String policyName) {
        return new File(this.storeFiles.getPolicyFolder(policyName), "encrypted-properties.yaml");
    }

    @Override
    public boolean remove(String policyName) {
        try {
            if (this.contains(policyName)) {
                FileUtils.deleteDirectory((File)this.storeFiles.getPolicyFolder(policyName));
            }
            this.cleanDeploymentFailures(policyName);
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Error trying to delete policy folder {}. {}", (Object)policyName, (Object)ExceptionDescriptor.errorMessage((Throwable)e));
            return false;
        }
    }

    @Override
    public void store(PolicyDefinition policyDefinition) {
        File destFolder = this.storeFiles.getPolicyFolder(policyDefinition.getName());
        PolicyFolders.createDirectoryIfNecessary((File)destFolder);
        try {
            this.storePolicyDefinition(policyDefinition, destFolder);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error storing policy " + policyDefinition.getName(), e);
        }
    }

    @Override
    public void store(Policy policy) {
        File destFolder = this.storeFiles.getPolicyFolder(policy.getPolicyDefinition().getName());
        PolicyFolders.createDirectoryIfNecessary((File)destFolder);
        try {
            this.storePolicyDefinition(policy.getPolicyDefinition(), destFolder);
            this.storePolicyConfiguration(policy.getResolvedTemplate(), destFolder);
            this.encryptedPropertiesSerializer.store(policy.getConfigFile(), destFolder);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error storing policy " + policy.getPolicyDefinition().getName(), e);
        }
    }

    @Override
    public void storeDeploymentFailure(PolicyDefinition policyDefinition, ApiKey apiKey, Exception exception) {
        String fileName = this.deploymentFailureFileName(policyDefinition, apiKey);
        File failureFile = new File(this.storeFiles.getFailedPoliciesFolder(), fileName);
        try {
            FileUtils.write((File)failureFile, (CharSequence)("Error deploying policy " + policyDefinition.getName() + " to " + apiKey + ":\n"));
            FileUtils.write((File)failureFile, (CharSequence)ExceptionUtils.getStackTrace((Throwable)exception), (boolean)true);
        }
        catch (IOException e) {
            LOGGER.warn("Could not write failure to failed-policies for {}. {}", (Object)policyDefinition.getName(), (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
    }

    @Override
    public void cleanDeploymentFailure(PolicyDefinition policyDefinition, ApiKey apiKey) {
        String fileName = this.deploymentFailureFileName(policyDefinition, apiKey);
        FileUtils.deleteQuietly((File)new File(this.storeFiles.getFailedPoliciesFolder(), fileName));
        if (this.storeFiles.listPolicyDeploymentFailures().isEmpty()) {
            FileUtils.deleteQuietly((File)this.storeFiles.getFailedPoliciesFolder());
        }
    }

    @Override
    public void cleanDeploymentFailures(String policyName) {
        this.storeFiles.listPolicyDeploymentFailures().stream().filter(file -> policyName.equals(StringUtils.substringBefore((String)file.getName(), (String)"@"))).forEach(FileUtils::deleteQuietly);
        if (this.storeFiles.listPolicyDeploymentFailures().isEmpty()) {
            FileUtils.deleteQuietly((File)this.storeFiles.getFailedPoliciesFolder());
        }
    }

    private List<PolicyDefinition> loadPolicyDefinitions(List<File> policyFolders) {
        return policyFolders.stream().map(this::loadPolicyDefinition).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    private Optional<PolicyDefinition> loadPolicyDefinition(File policyFolder) {
        try {
            File policyFile = new File(policyFolder, POLICY_DEFINITION_JSON_FILE_NAME);
            return Optional.of(this.policyDefinitionSerializer.deserializeFromFile(policyFile));
        }
        catch (Exception e) {
            LOGGER.error("Could not read policy from JSON file in {}. {}", (Object)policyFolder.getName(), (Object)ExceptionDescriptor.errorMessage((Throwable)e));
            return Optional.empty();
        }
    }

    private void storePolicyConfiguration(String resolvedTemplate, File destFolder) throws IOException {
        if (resolvedTemplate != null) {
            FileUtils.write((File)new File(destFolder, POLICY_CONFIG_XML_FILE_NAME), (CharSequence)resolvedTemplate);
        }
    }

    private void storePolicyDefinition(PolicyDefinition policyDefinition, File destFolder) throws IOException {
        this.policyDefinitionSerializer.serializeToFile(policyDefinition, new File(destFolder, POLICY_DEFINITION_JSON_FILE_NAME));
    }

    private String deploymentFailureFileName(PolicyDefinition policyDefinition, ApiKey apiKey) {
        return policyDefinition.getName() + "@" + apiKey.id() + ".log";
    }
}

