/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class PolicyDefinitionTestCase
extends AbstractMuleTestCase {
    @Test
    public void definitionsAreEquals() {
        HttpResourcePointcut resourcePointcut = new HttpResourcePointcut(".*", "GET");
        HttpResourcePointcut resourcePointcut2 = new HttpResourcePointcut(".*", "GET");
        ApiKey apiKey = new ApiKey(Long.valueOf(1L));
        ApiKey apiKey2 = new ApiKey(Long.valueOf(1L));
        PolicyConfiguration policyConfiguration = new PolicyConfiguration((Map)ImmutableMap.of((Object)"string", (Object)"value", (Object)"int", (Object)60000, (Object)"object", (Object)ImmutableMap.of((Object)"prop", (Object)"value")));
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, apiKey, (List)Lists.newArrayList((Object[])new HttpResourcePointcut[]{resourcePointcut}), 1, policyConfiguration);
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, apiKey2, (List)Lists.newArrayList((Object[])new HttpResourcePointcut[]{resourcePointcut2}), 1, policyConfiguration);
        Assert.assertEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentIdNotEquals() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        Assert.assertNotEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentVersionEquals() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "1", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "2", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        Assert.assertEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentTemplateNotEquals() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        Assert.assertNotEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentApiNotEquals() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY_2, (List)Lists.newArrayList(), 1, this.emptyConfig());
        Assert.assertNotEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentResourcePointcutNotEquals() {
        HttpResourcePointcut resourcePointcut = new HttpResourcePointcut(".*", "GET");
        HttpResourcePointcut resourcePointcut2 = new HttpResourcePointcut(".*", "POST");
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList((Object[])new HttpResourcePointcut[]{resourcePointcut}), 1, this.emptyConfig());
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList((Object[])new HttpResourcePointcut[]{resourcePointcut2}), 1, this.emptyConfig());
        Assert.assertNotEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentOrderNotEquals() {
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, this.emptyConfig());
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 2, this.emptyConfig());
        Assert.assertNotEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    @Test
    public void differentConfigDataNotEquals() {
        PolicyConfiguration policyConfiguration = new PolicyConfiguration((Map)ImmutableMap.of((Object)"string", (Object)"value2"));
        PolicyConfiguration policyConfiguration2 = new PolicyConfiguration((Map)ImmutableMap.of((Object)"string", (Object)"value"));
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, policyConfiguration);
        PolicyDefinition policyDefinition2 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, policyConfiguration2);
        Assert.assertNotEquals((Object)policyDefinition, (Object)policyDefinition2);
    }

    private PolicyConfiguration emptyConfig() {
        return new PolicyConfiguration(Collections.emptyMap());
    }
}

