/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyListener;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyWatcher;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.LogCleanup;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class OfflinePolicyWatcherTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemPropertyTemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private MultiplexingPolicyDeploymentService policyDeploymentService;
    private TestLogger logger;

    @Before
    public void setUp() throws MuleException {
        this.policyDeploymentService = (MultiplexingPolicyDeploymentService)Mockito.mock(MultiplexingPolicyDeploymentService.class);
        OfflinePolicyWatcher offlinePolicyWatcher = new OfflinePolicyWatcher(this.policyDeploymentService);
        this.overrideLogger(offlinePolicyWatcher);
        offlinePolicyWatcher.initialise();
        offlinePolicyWatcher.start();
    }

    @Test
    public void newFileIsDetected() throws URISyntaxException, IOException {
        File offlineDefinitionFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json");
        OfflinePolicyWatcherTestCase.atomicCopyFile(this.definitionFile(), offlineDefinitionFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    @Test
    public void invalidDefinitionNotDeployed() throws URISyntaxException, IOException, InterruptedException {
        File offlineDefinitionFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json");
        OfflinePolicyWatcherTestCase.atomicCopyFile(this.invalidDefinitionFile(), offlineDefinitionFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService})));
    }

    @Test
    public void invalidExtensionInNewFileIsIgnored() throws URISyntaxException, IOException, InterruptedException {
        File invalidFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy.xml");
        OfflinePolicyWatcherTestCase.atomicCopyFile(this.invalidExtensionFile(), invalidFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            TestCase.assertTrue((boolean)this.logger.getAllLoggingEvents().stream().anyMatch(logLine -> logLine.getMessage().contains("Invalid extension")));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    @Test
    public void modificationIsDetected() throws URISyntaxException, IOException {
        OfflinePolicyWatcherTestCase.atomicCopyFile(this.definitionFile(), new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json"));
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)ArgumentMatchers.any())));
        FileUtils.copyFile((File)this.updatedDefinitionFile(), (File)new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json"));
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.atLeast((int)2))).newPolicy((PolicyDefinition)ArgumentMatchers.any());
            ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.atLeast((int)1))).removePolicy((PolicyDefinition)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    @Test
    public void removeIsDetected() throws URISyntaxException, IOException {
        File offlineDefinitionFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json");
        OfflinePolicyWatcherTestCase.atomicCopyFile(this.definitionFile(), offlineDefinitionFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)ArgumentMatchers.any())));
        boolean deleted = offlineDefinitionFile.delete();
        TestCase.assertTrue((boolean)deleted);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)ArgumentMatchers.any());
            ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicyById("policy-definition");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    private File definitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/full-definition.json").toURI());
    }

    private File updatedDefinitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/updated-definition.json").toURI());
    }

    private File invalidDefinitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/offline-invalid-field-definition.json").toURI());
    }

    private File invalidExtensionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/templates/template.xml").toURI());
    }

    private void overrideLogger(OfflinePolicyWatcher offlinePolicyWatcher) {
        OfflinePolicyListener offlinePolicyListener = (OfflinePolicyListener)new Inspector((Object)offlinePolicyWatcher).read("listener");
        this.logger = TestLoggerFactory.getTestLogger(offlinePolicyListener.getClass());
    }

    public static void atomicCopyFile(File srcFile, File destFile) throws IOException {
        File tmp = org.codehaus.plexus.util.FileUtils.createTempFile((String)"working", (String)"save", null);
        FileUtils.copyFile((File)srcFile, (File)tmp);
        FileUtils.moveFile((File)tmp, (File)destFile, (CopyOption[])new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
    }
}

