/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.policies.pointcut.ApiPointcutAdapter;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.LogCleanup;
import uk.org.lidalia.slf4jext.Level;

public class ApiPointcutAdapterTestCase
extends AbstractMuleTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private static final String POLICY_NAME = "name";
    private static final String FLOW_NAME = "FlowName";
    private static final String FLOW_NAME_LOWER_CASE = "flowname";
    private static final String FLOW_NAME_2 = "otherFlowName";
    private ApiPointcutAdapter pointcut;
    private TestLogger logger;

    @Before
    public void setUp() {
        this.pointcut = new ApiPointcutAdapter(POLICY_NAME, FLOW_NAME);
        this.logger = TestLoggerFactory.getTestLogger(this.pointcut.getClass());
    }

    @Test
    public void apiMatchesListenerParameters() {
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters(FLOW_NAME);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Executing flow matches API's flow {} for policy {}", new Object[]{FLOW_NAME, POLICY_NAME})));
    }

    @Test
    public void apiMatchesRequestParameters() {
        PolicyPointcutParameters parameters = PointcutTestUtils.requesterPointcutParameters(FLOW_NAME);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Executing flow matches API's flow {} for policy {}", new Object[]{FLOW_NAME, POLICY_NAME})));
    }

    @Test
    public void differentFlowNamesDoesNotMatch() {
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters(FLOW_NAME_2);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Executing flow {} does not match API's flow {} for policy {}", new Object[]{FLOW_NAME_2, FLOW_NAME, POLICY_NAME})));
    }

    @Test
    public void differentFlowNameCasingDoesNotMatch() {
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters(FLOW_NAME_LOWER_CASE);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Executing flow {} does not match API's flow {} for policy {}", new Object[]{FLOW_NAME_LOWER_CASE, FLOW_NAME, POLICY_NAME})));
    }
}

