/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import java.util.Map;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringRegularExpression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.tck.junit4.rule.LogCleanup;
import uk.org.lidalia.slf4jext.Level;

public class HttpResourcePointcutTestCase {
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private TestLogger logger;

    @Before
    public void setUp() {
        this.logger = TestLoggerFactory.getTestLogger(HttpResourcePointcut.class);
    }

    @Test
    public void resourceMatchesListenerParameters() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/path", "Get");
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void resourceMatchesRequestParameters() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/path", "Get");
        PolicyPointcutParameters parameters = PointcutTestUtils.requesterPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void resourceDifferentCasingMatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/PATH", "GET");
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void regexPatternsMatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut(".*", ".*");
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "Get", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request {{}, {}} matches the following resource pointcut: {}", new Object[]{"/path", "Get", pointcut})));
    }

    @Test
    public void pathMismatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut("/path", ".*");
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/pathh", "POST", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request {{}, {}} does not match the following resource pointcut: {}", new Object[]{"/pathh", "POST", pointcut})));
    }

    @Test
    public void methodMismatches() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut(".*", "GET");
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("", "/path", "POST", (Map<QName, Object>)ImmutableMap.of());
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "Request {{}, {}} does not match the following resource pointcut: {}", new Object[]{"/path", "POST", pointcut})));
    }

    @Test
    public void invalidParametersType() {
        HttpResourcePointcut pointcut = new HttpResourcePointcut(".*", "GET");
        PolicyPointcutParameters parameters = PointcutTestUtils.nonHttpPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)).getMessage(), (Matcher)Matchers.is((Object)"Invalid parameters type found. {}"));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)).getArguments().get(0).toString(), (Matcher)StringRegularExpression.matchesRegex((String)".*org\\.mule\\.runtime\\.policy\\.api\\.PolicyPointcutParameters cannot be cast to( class)? org\\.mule\\.runtime\\.http\\.policy\\.api\\.HttpPolicyPointcutParameters.*"));
    }
}

