/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyParametrizationIdCache;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import java.io.File;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultPolicyParametrizationIdCacheTestCase {
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    private static final String FLOW_NAME = "flowName";
    private static final String SECOND_FLOW_NAME = "secondFlowName";
    private final DefaultPolicyParametrizationIdCache cache = new DefaultPolicyParametrizationIdCache();
    private final PolicyParametrizationFactory policyParametrizationFactory = new PolicyParametrizationFactory();
    @Mock
    private Api api;
    @Mock
    private PolicySpecification policySpecification;
    private Policy policy;
    private Policy policyTwo;
    private PolicyDefinition policyDefinition;
    private PolicyDefinition policyDefinitionTwo;
    private PolicyTemplate policyTemplate;
    private ApiImplementation apiImplementation;
    private ApiImplementation newApiImplementation;
    private String parametrizationId;
    private String newParametrizationId;

    @Before
    public void setUp() throws PolicyTemplateResolverException {
        this.apiImplementation = this.getApiImplementation(FLOW_NAME);
        this.newApiImplementation = this.getApiImplementation(SECOND_FLOW_NAME);
        this.policyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policyTemplate = new PolicyTemplate(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (File)Mockito.mock(File.class), this.policySpecification, new PolicyTemplateDescriptor(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        MuleVersion muleVersion = new MuleVersion("4.6.0");
        this.policyTemplate.getTemplateDescriptor().setMinMuleVersion(muleVersion);
        this.policy = new Policy(this.policyTemplate, this.policyDefinition, RESOLVED_TEMPLATE);
        PolicyTemplate template = (PolicyTemplate)Mockito.mock(PolicyTemplate.class);
        this.policyDefinitionTwo = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, PolicyTestValuesConstants.API_KEY_2, Collections.emptyList(), 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policyTwo = new Policy(template, this.policyDefinitionTwo, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
    }

    @Test
    public void storeAndGet() {
        this.parametrizationId = this.policyParametrizationFactory.buildParametrizationId(this.policy, this.apiImplementation);
        this.cache.store(this.policy, this.api, this.parametrizationId);
        Assert.assertThat((Object)this.parametrizationId, (Matcher)Is.is((Object)this.cache.get(this.policyDefinition, this.api)));
    }

    @Test
    public void storeOnePolicyAndRemoveIt() {
        this.parametrizationId = this.policyParametrizationFactory.buildParametrizationId(this.policy, this.apiImplementation);
        this.cache.store(this.policy, this.api, this.parametrizationId);
        this.cache.remove(this.policyDefinition, this.api);
        Assert.assertThat(null, (Matcher)Is.is((Object)this.cache.get(this.policyDefinition, this.api)));
    }

    @Test
    public void storeTwoPoliciesAndRemoveOne() {
        this.parametrizationId = this.policyParametrizationFactory.buildParametrizationId(this.policy, this.apiImplementation);
        this.newParametrizationId = this.policyParametrizationFactory.buildParametrizationId(this.policy, this.newApiImplementation);
        this.cache.store(this.policy, this.api, this.parametrizationId);
        this.cache.store(this.policyTwo, this.api, this.newParametrizationId);
        this.cache.remove(this.policyDefinition, this.api);
        Assert.assertThat(null, (Matcher)Is.is((Object)this.cache.get(this.policyDefinition, this.api)));
        Assert.assertThat((Object)this.newParametrizationId, (Matcher)Is.is((Object)this.cache.get(this.policyDefinitionTwo, this.api)));
    }

    @Test
    public void storeSamePolicyWithTwoApis() {
        Api api2 = (Api)Mockito.mock(Api.class);
        this.parametrizationId = this.policyParametrizationFactory.buildParametrizationId(this.policy, this.apiImplementation);
        this.newParametrizationId = this.policyParametrizationFactory.buildParametrizationId(this.policy, this.newApiImplementation);
        this.cache.store(this.policy, this.api, this.parametrizationId);
        this.cache.store(this.policy, api2, this.newParametrizationId);
        Assert.assertThat((Object)this.parametrizationId, (Matcher)Is.is((Object)this.cache.get(this.policyDefinition, this.api)));
        Assert.assertThat((Object)this.newParametrizationId, (Matcher)Is.is((Object)this.cache.get(this.policyDefinition, api2)));
    }

    private ApiImplementation getApiImplementation(String flowName) {
        return this.getApiImplementation(null, flowName);
    }

    private ApiImplementation getApiImplementation(String hdpService, String flowName) {
        return this.getApiImplementation(hdpService, false, flowName);
    }

    private ApiImplementation getApiImplementation(String hdpService, boolean ignoreBasePathOnResourceLevel, String flowName) {
        return this.getApiImplementation(hdpService, "app", ignoreBasePathOnResourceLevel, flowName);
    }

    private ApiImplementation getApiImplementation(String hdpService, String appName, boolean ignoreBasePathOnResourceLevel, String flowName) {
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)application.getArtifactName()).thenReturn((Object)appName);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getName()).thenReturn((Object)flowName);
        return new ApiImplementation(PolicyTestValuesConstants.API_KEY, application, flow, hdpService, ignoreBasePathOnResourceLevel);
    }
}

