/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultTransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class TransactionalPolicyDeploymentServiceTestCase
extends AbstractMuleTestCase {
    private static final PolicyDefinition definition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, new PolicyConfiguration(Collections.emptyMap()));
    private static final PolicyDefinition differentDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, new PolicyConfiguration(Collections.singletonMap("param", "value")));
    private static final PolicyDefinition differentTemplateDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, new PolicyConfiguration(Collections.emptyMap()));
    private static final Policy policy = new Policy(null, definition, "");
    private static final Policy differentPolicy = new Policy(null, differentDefinition, "");
    private static final Policy differentTemplatePolicy = new Policy(null, differentTemplateDefinition, "");
    private static final String definitionName = definition.getName();
    private static final String differentTemplateName = differentTemplateDefinition.getName();
    private Api api;
    private PolicyStore policyStore;
    private PolicyDeploymentTracker policyDeploymentTracker;
    private PolicyDeployer policyDeployer;
    private TransactionalPolicyDeploymentService transactionalDeployer;
    private PolicyFactory policyFactory;

    @Before
    public void setUp() {
        this.api = this.mockAPi();
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.policyStore = (PolicyStore)Mockito.mock(PolicyStore.class);
        this.policyDeployer = (PolicyDeployer)Mockito.mock(PolicyDeployer.class);
        this.policyFactory = (PolicyFactory)Mockito.mock(PolicyFactory.class);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(definition)).thenReturn((Object)policy);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(differentDefinition)).thenReturn((Object)differentPolicy);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(differentTemplateDefinition)).thenReturn((Object)differentTemplatePolicy);
        this.transactionalDeployer = new DefaultTransactionalPolicyDeploymentService(this.policyDeploymentTracker, this.policyStore, this.policyFactory, this.policyDeployer);
    }

    @Test
    public void reorderSuccess() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void hotReorderFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(policy, this.api);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void hotReorderFailsUpdateFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentPolicy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(differentDefinition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(differentDefinition, definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(policy, this.api);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentPolicy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(differentDefinition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void hotReorderFailsUpdateFailsRevertFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.updateOrder(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentPolicy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(differentDefinition));
        this.transactionalDeployer.updateOrder(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.revertFailed(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).updateOrder(policy, this.api);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentPolicy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateSuccess() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentPolicy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(differentDefinition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(differentDefinition, definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentPolicy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(differentDefinition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateFailsRevertFails() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentPolicy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(differentDefinition));
        this.transactionalDeployer.update(differentDefinition, definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.revertFailed(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).undeploy(differentDefinition, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).remove(definitionName);
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentPolicy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateWhenFailedDeploy() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.deploymentFailed(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        this.transactionalDeployer.deploy(definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void updateFailsWhenFailedDeploy() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.deploymentFailed(differentDefinition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.deploymentFailedDefinition(definition));
        this.transactionalDeployer.deploy(definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.deploymentFailed(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(policy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY, null);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void revertPolicy() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.deploymentFailed(definition, differentDefinition));
        this.transactionalDeployer.revertPolicy(definition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(definition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(definition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void recoverWithDifferentTemplate() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.downloadFailed(definition));
        Mockito.when((Object)this.policyDeployer.deploy(differentTemplatePolicy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(differentTemplateDefinition));
        this.transactionalDeployer.deploy(differentTemplateDefinition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.applied(differentTemplateDefinition)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore});
        ((PolicyDeployer)inOrder.verify((Object)this.policyDeployer)).deploy(differentTemplatePolicy, this.api);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).cleanDeploymentFailure(differentTemplateDefinition, PolicyTestValuesConstants.API_KEY);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void invalidTemplateReceived() {
        PolicyTemplateAssetException exception = new PolicyTemplateAssetException("", null);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.applied(definition));
        Mockito.when((Object)this.policyDeployer.undeploy(definition, this.api)).thenReturn((Object)true);
        Mockito.when((Object)this.policyDeployer.deploy(policy, this.api)).thenReturn((Object)DeploymentStatusTestFactory.appliedDefinition(definition));
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(differentTemplateDefinition)).thenThrow(new Throwable[]{exception});
        this.transactionalDeployer.update(definition, differentTemplateDefinition, this.api);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)), (Matcher)Is.is((Object)DeploymentStatusTestFactory.downloadFailed(definition, differentTemplateDefinition, (Exception)((Object)exception))));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.policyDeployer, this.policyStore, this.policyFactory});
        ((PolicyFactory)inOrder.verify((Object)this.policyFactory)).createFromPolicyDefinition(differentTemplateDefinition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).store(definition);
        ((PolicyStore)inOrder.verify((Object)this.policyStore)).storeDeploymentFailure(differentTemplateDefinition, PolicyTestValuesConstants.API_KEY, (Exception)((Object)exception));
        inOrder.verifyNoMoreInteractions();
    }

    private Api mockAPi() {
        Api api = (Api)Mockito.mock(Api.class);
        ApiImplementation impl = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Mockito.when((Object)api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)api.getImplementation()).thenReturn((Object)impl);
        Mockito.when((Object)impl.getApiKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)impl.getArtifactName()).thenReturn((Object)"MyArtifact");
        return api;
    }
}

