/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicySpecificationBuilder;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.GatewayPolicyTemplateDescriptorFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.slf4j.Logger;

public abstract class PolicyTemplateProvider {
    static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(PolicyTemplateProvider.class);
    private static final String TEMPLATE_FILE_NAME = "template.xml";
    protected final PolicyTemplateStore policyTemplateStore;
    private final Map<PolicyTemplateKey, PolicyTemplate> policyTemplateMap = new HashMap<PolicyTemplateKey, PolicyTemplate>();
    private final GatewayPolicyTemplateDescriptorFactory templateDescriptorFactory;

    public PolicyTemplateProvider(GatewayPolicyTemplateDescriptorFactory templateDescriptorFactory, PolicyTemplateStore policyTemplateStore) {
        this.templateDescriptorFactory = templateDescriptorFactory;
        this.policyTemplateStore = policyTemplateStore;
    }

    public synchronized PolicyTemplate provide(PolicyTemplateKey templateKey) {
        PolicyTemplate policyTemplate = this.policyTemplateMap.get(templateKey);
        if (policyTemplate == null || !policyTemplate.getTemplateDescriptor().getRootFolder().exists()) {
            PolicyTemplateAssets templateAssets = this.getPolicyTemplateAssets(templateKey);
            try {
                org.mule.runtime.core.api.util.FileUtils.unzip((File)templateAssets.getTemplateJarFile(), (File)templateAssets.getTemplateExtractedJarFolder());
            }
            catch (IOException e) {
                if (FileUtils.deleteQuietly((File)templateAssets.getTemplateJarFile())) {
                    LOGGER.debug("Policy template JAR {} was deleted successfully", (Object)templateAssets.getTemplateJarFile().getName());
                }
                throw new PolicyTemplateAssetException("Error processing policy template file for " + templateKey.getName(), e);
            }
            PolicyTemplateDescriptor templateDescriptor = this.templateDescriptorFactory.create(templateAssets.getTemplateExtractedJarFolder(), Optional.empty());
            PolicySpecification policySpecification = new PolicySpecificationBuilder().withFile(templateAssets.getTemplateYamlFile()).build();
            File templateFile = new File(templateAssets.getTemplateExtractedJarFolder(), TEMPLATE_FILE_NAME);
            policyTemplate = new PolicyTemplate(templateKey, templateFile, policySpecification, templateDescriptor);
            this.policyTemplateMap.put(templateKey, policyTemplate);
        }
        return policyTemplate;
    }

    protected abstract PolicyTemplateAssets getPolicyTemplateAssets(PolicyTemplateKey var1);
}

