/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecycle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.HdpApisHealthCheckListener;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.Application;

public class HdpApiHealthCheckListenerTestCase {
    private Long apiId = 101L;
    private Application application = (Application)Mockito.mock(Application.class);
    private Flow flow = (Flow)Mockito.mock(Flow.class);
    private ApiKey apiKey = new ApiKey(this.apiId);
    private PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
    private List<PolicyDefinitionDeploymentStatus> policyDeploymentStatus = (List)Mockito.mock(List.class);
    private Api api = (Api)Mockito.mock(Api.class);
    private ApiService apiService = (ApiService)Mockito.mock(ApiService.class);
    private HdpApisHealthCheckListener hdpApisHealthCheckListener = new HdpApisHealthCheckListener(this.apiService);
    private ApiImplementation apiImplementation;

    @Before
    public void setup() {
        this.apiImplementation = new ApiImplementation(this.apiKey, this.application, this.flow, "some", false);
        this.apiImplementation.gatekeeperStatus().blocked(false);
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)this.apiKey);
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)this.apiImplementation);
        Mockito.when((Object)this.apiService.get(this.apiKey)).thenReturn(Optional.of(this.api));
    }

    @Test
    public void blockApi() {
        Assert.assertThat((Object)this.api.getImplementation().gatekeeperStatus().isBlocked(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void unblockApi() {
        this.hdpApisHealthCheckListener.onPolicySetDeploymentCompleted(this.apiKey, this.policySet, this.policyDeploymentStatus);
        Assert.assertThat((Object)this.api.getImplementation().gatekeeperStatus().isBlocked(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void doNotUnblockMoreThanOnce() {
        ApiImplementation impl = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Mockito.when((Object)impl.isHdp()).thenReturn((Object)true);
        GatekeeperStatusTracker status = (GatekeeperStatusTracker)Mockito.mock(GatekeeperStatusTracker.class);
        Mockito.when((Object)impl.gatekeeperStatus()).thenReturn((Object)status);
        Mockito.when((Object)status.isBlocked()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)status.shouldUnblock()).thenReturn((Object)true);
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)impl);
        this.hdpApisHealthCheckListener.onPolicySetDeploymentCompleted(this.apiKey, this.policySet, this.policyDeploymentStatus);
        this.hdpApisHealthCheckListener.onPolicySetDeploymentCompleted(this.apiKey, this.policySet, this.policyDeploymentStatus);
        ((GatekeeperStatusTracker)Mockito.verify((Object)this.api.getImplementation().gatekeeperStatus(), (VerificationMode)Mockito.times((int)1))).unblocked();
    }
}

