/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck;

import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck.ReadyStatusFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck.TextReadyStatusFactory;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.healthcheck.ReadyStatus;

public class TextAppReadyStatusFactoryTestCase {
    private final ReadyStatusFactory appFactory = new TextReadyStatusFactory();
    private final ReadyStatus readyApi1 = this.appFactory.readyStatus(Long.valueOf(1L), GatekeeperStatus.READY);
    private final ReadyStatus readyApi2 = this.appFactory.readyStatus(Long.valueOf(2L), GatekeeperStatus.READY);
    private final ReadyStatus untrackedApi1 = this.appFactory.readyStatus(Long.valueOf(1L), GatekeeperStatus.UNTRACKED);
    private final ReadyStatus untrackedApi2 = this.appFactory.readyStatus(Long.valueOf(2L), GatekeeperStatus.UNTRACKED);

    @Test
    public void oneApiReadyAndOneNot() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Arrays.asList(this.readyApi1, this.untrackedApi2));
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)"Gatekeeper is blocking the app due to:\nAPI 1: Ready.\nAPI 2: Not Ready. API not found in the API Platform."));
    }

    @Test
    public void orderedStatus() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Arrays.asList(this.untrackedApi2, this.readyApi1));
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)"Gatekeeper is blocking the app due to:\nAPI 1: Ready.\nAPI 2: Not Ready. API not found in the API Platform."));
    }

    @Test
    public void twoApisReady() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Arrays.asList(this.readyApi1, this.readyApi2));
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)"API 1: Ready.\nAPI 2: Ready."));
    }

    @Test
    public void twoApisBlocked() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Arrays.asList(this.untrackedApi1, this.untrackedApi2));
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)"Gatekeeper is blocking the app due to:\nAPI 1: Not Ready. API not found in the API Platform.\nAPI 2: Not Ready. API not found in the API Platform."));
    }

    @Test
    public void singleApiNotReady() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Collections.singletonList(this.untrackedApi1));
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)"API 1: Not Ready. API not found in the API Platform."));
    }

    @Test
    public void singleApiReady() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Collections.singletonList(this.readyApi1));
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)"API 1: Ready."));
    }

    @Test
    public void emptyStatusList() {
        ReadyStatus readyStatus = this.appFactory.readyStatus(Collections.emptyList());
        MatcherAssert.assertThat((Object)readyStatus.isReady(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)readyStatus.statusDescription().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)readyStatus.statusDescription().get()), (Matcher)Is.is((Object)""));
    }
}

