/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.mulesoft.mule.runtime.gw.policies.pointcut.HttpHeaderPointcut;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.policy.api.HttpPolicyPointcutParameters;
import org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpHeaderPointcutTestCase {
    private static final String POLICY_NAME = "name";
    @Mock
    private HttpPolicyPointcutParameters parameters;
    private MultiMap<String, String> requestHeaders = new CaseInsensitiveMultiMap();

    @Before
    public void setUp() {
        Mockito.when((Object)this.parameters.getSourceParameters()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameters.getHeaders()).thenReturn(this.requestHeaders);
    }

    @Test
    public void headerNotPresent() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "h1", ".*");
        Assert.assertThat((Object)pointcut.matches((PolicyPointcutParameters)this.parameters), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void matchOnlyValue() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "h1", "v1");
        this.requestHeaders.put((Object)"h1", (Object)"v1");
        Assert.assertThat((Object)pointcut.matches((PolicyPointcutParameters)this.parameters), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void matchOneOfMultipleValues() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "h1", ".2");
        this.requestHeaders.put((Object)"h1", (Object)"v1");
        this.requestHeaders.put((Object)"h1", (Object)"v2");
        this.requestHeaders.put((Object)"h1", (Object)"v3");
        Assert.assertThat((Object)pointcut.matches((PolicyPointcutParameters)this.parameters), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void differentCaseNameMatches() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "Hd1", "v1");
        this.requestHeaders.put((Object)"hD1", (Object)"v1");
        Assert.assertThat((Object)pointcut.matches((PolicyPointcutParameters)this.parameters), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void differentCaseValueDoesNotMatch() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "h1", "V1");
        this.requestHeaders.put((Object)"h1", (Object)"v1");
        Assert.assertThat((Object)pointcut.matches((PolicyPointcutParameters)this.parameters), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void substringDoesNotMatch() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "h1", "v1");
        this.requestHeaders.put((Object)"h1", (Object)"v11");
        Assert.assertThat((Object)pointcut.matches((PolicyPointcutParameters)this.parameters), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void sourcePolicyAwareAttributes() {
        HttpHeaderPointcut pointcut = new HttpHeaderPointcut(POLICY_NAME, "h1", "v1");
        SourcePolicyAwareAttributes policyAwareAttributes = (SourcePolicyAwareAttributes)pointcut.sourcePolicyAwareAttributes();
        Assert.assertThat((Object)policyAwareAttributes.requires((PolicyAwareAttributes.Attribute)SourcePolicyAwareAttributes.SourceAttribute.HEADERS), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)policyAwareAttributes.requires((PolicyAwareAttributes.Attribute)SourcePolicyAwareAttributes.SourceAttribute.REQUEST_PATH), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)policyAwareAttributes.getHeaders(), (Matcher)Matchers.is(Collections.singleton("h1")));
    }
}

