/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStoreFiles;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class PolicyStoreFilesTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_NAME = "policy-name";
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    private PolicyStoreFiles fileHandler;

    @Before
    public void setUp() throws IOException {
        this.fileHandler = new PolicyStoreFiles(this.muleHome.newFolder());
    }

    @Test
    public void listPolicyFoldersOnlyReturnsPolicyFolders() {
        PolicyFolders.getPolicyTemplatesFolder();
        PolicyFolders.getOfflinePoliciesFolder();
        this.fileHandler.getFailedPoliciesFolder().mkdir();
        this.fileHandler.getPolicyFolder(POLICY_NAME).mkdir();
        List folders = this.fileHandler.listPolicyFolders();
        Assert.assertThat((Object)folders, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((File)folders.get(0)).getName(), (Matcher)Matchers.is((Object)POLICY_NAME));
    }

    @Test
    public void listFailedPolicyFoldersReturnsEmptyWhenFailedPoliciesFolderDoesNotExist() {
        PolicyFolders.getPolicyTemplatesFolder();
        this.fileHandler.getPolicyFolder(POLICY_NAME).mkdir();
        List files = this.fileHandler.listPolicyDeploymentFailures();
        Assert.assertThat((Object)files, (Matcher)Matchers.empty());
    }

    @Test
    public void getFailedPoliciesFolderDoesNotCreateIt() {
        File folder = this.fileHandler.getFailedPoliciesFolder();
        Assert.assertThat((Object)folder.exists(), (Matcher)Matchers.is((Object)false));
    }
}

