/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class PolicyTemplateStoreTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    private PolicyTemplateStore policyTemplateStore;

    @Before
    public void setup() {
        this.policyTemplateStore = new PolicyTemplateStore();
    }

    @Test
    public void storeJar() throws IOException {
        this.policyTemplateStore.storeJar(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, IOUtils.toInputStream((String)"some-jar", (Charset)Charset.defaultCharset()));
        File[] files = PolicyFolders.getPolicyTemplatesFolder().listFiles();
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)files[0].getName(), (Matcher)CoreMatchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName() + "-mule-policy.jar")));
        MatcherAssert.assertThat((Object)FileUtils.readFileToString((File)files[0], (Charset)Charset.defaultCharset()), (Matcher)CoreMatchers.is((Object)"some-jar"));
    }

    @Test
    public void storeYaml() throws IOException {
        this.policyTemplateStore.storeYaml(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, IOUtils.toInputStream((String)"some-yaml", (Charset)Charset.defaultCharset()));
        File[] files = PolicyFolders.getPolicyTemplatesFolder().listFiles();
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)files[0].getName(), (Matcher)CoreMatchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName() + ".yaml")));
        MatcherAssert.assertThat((Object)FileUtils.readFileToString((File)files[0], (Charset)Charset.defaultCharset()), (Matcher)CoreMatchers.is((Object)"some-yaml"));
    }

    @Test
    public void storeInternalJar() throws IOException {
        this.policyTemplateStore.storeInternalJar(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, IOUtils.toInputStream((String)"some-internal-jar", (Charset)Charset.defaultCharset()));
        File[] files = PolicyFolders.getPolicyTemplatesTempFolder().listFiles();
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)files[0].getName(), (Matcher)CoreMatchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName() + "-mule-policy.jar")));
        MatcherAssert.assertThat((Object)FileUtils.readFileToString((File)files[0], (Charset)Charset.defaultCharset()), (Matcher)CoreMatchers.is((Object)"some-internal-jar"));
    }

    @Test
    public void allAssets() throws IOException {
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.writeStringToFile((File)templateAssets.getTemplateJarFile(), (String)"some-jar", (Charset)Charset.defaultCharset());
        FileUtils.writeStringToFile((File)templateAssets.getTemplateYamlFile(), (String)"some-yaml", (Charset)Charset.defaultCharset());
        FileUtils.writeStringToFile((File)this.fileWithinExtractedJarFolder(templateAssets), (String)"some-content", (Charset)Charset.defaultCharset());
        PolicyTemplateAssets templateAssets2 = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2);
        FileUtils.writeStringToFile((File)templateAssets2.getTemplateJarFile(), (String)"some-jar", (Charset)Charset.defaultCharset());
        FileUtils.writeStringToFile((File)templateAssets2.getTemplateYamlFile(), (String)"some-yaml", (Charset)Charset.defaultCharset());
        FileUtils.writeStringToFile((File)this.fileWithinExtractedJarFolder(templateAssets2), (String)"some-content", (Charset)Charset.defaultCharset());
        List allAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allAssets, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(allAssets.stream().map(PolicyTemplateAssets::getTemplateName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName(), PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2.getName()}));
    }

    @Test
    public void allAssetsReturnsAssetsWithOnlyJars() throws IOException {
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.writeStringToFile((File)templateAssets.getTemplateJarFile(), (String)"some-jar", (Charset)Charset.defaultCharset());
        List allAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allAssets, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyTemplateAssets)allAssets.get(0)).getTemplateName(), (Matcher)CoreMatchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
    }

    @Test
    public void allAssetsReturnsAssetsWithJustExplodedJars() throws IOException {
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.writeStringToFile((File)this.fileWithinExtractedJarFolder(templateAssets), (String)"some-content", (Charset)Charset.defaultCharset());
        List allAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allAssets, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyTemplateAssets)allAssets.get(0)).getTemplateName(), (Matcher)CoreMatchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
    }

    @Test
    public void allAssetsReturnsAssetsWithBothOnlyExplodedJarsAndOnlyJars() throws IOException {
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.writeStringToFile((File)this.fileWithinExtractedJarFolder(templateAssets), (String)"some-content", (Charset)Charset.defaultCharset());
        PolicyTemplateAssets templateAssets2 = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2);
        FileUtils.writeStringToFile((File)templateAssets2.getTemplateJarFile(), (String)"some-jar", (Charset)Charset.defaultCharset());
        List allAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allAssets, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(allAssets.stream().map(PolicyTemplateAssets::getTemplateName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName(), PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2.getName()}));
    }

    @Test
    public void whenTempDirectoryDoesNotExistGettingAllAssetsDoesNotFails() {
        List allAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allAssets, (Matcher)Matchers.empty());
    }

    private File fileWithinExtractedJarFolder(PolicyTemplateAssets templateAssets) {
        MatcherAssert.assertThat((Object)templateAssets.getTemplateExtractedJarFolder().mkdirs(), (Matcher)CoreMatchers.is((Object)true));
        return new File(templateAssets.getTemplateExtractedJarFolder(), "some-file");
    }
}

