/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicyDefinitionSerializer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class PolicyDefinitionSerializerTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_VERSION = "version";
    private static final String CONFIG_HASH = "202020202";
    private PolicyDefinitionSerializer policyDefinitionSerializer = new PolicyDefinitionSerializer();

    @Test
    public void serializeFullDefinition() throws IOException {
        File destFile = this.createTempFile();
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(PolicyTestValuesConstants.CONFIG_DATA);
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", POLICY_VERSION, PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.RESOURCE_POINTCUTS, 1, policyConfiguration);
        this.policyDefinitionSerializer.serializeToFile(policyDefinition, destFile);
        Assert.assertEquals((Object)IOUtils.getResourceAsString((String)"json/full-definition.json", ((Object)((Object)this)).getClass()).trim(), (Object)FileUtils.readFileToString((File)destFile).trim());
    }

    @Test
    public void serializeFullDefinitionWithHash() throws IOException {
        File destFile = this.createTempFile();
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(PolicyTestValuesConstants.CONFIG_DATA, CONFIG_HASH);
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", POLICY_VERSION, PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.RESOURCE_POINTCUTS, 1, policyConfiguration);
        this.policyDefinitionSerializer.serializeToFile(policyDefinition, destFile);
        Assert.assertEquals((Object)IOUtils.getResourceAsString((String)"json/full-definition-hash.json", ((Object)((Object)this)).getClass()).trim(), (Object)FileUtils.readFileToString((File)destFile).trim());
    }

    @Test
    public void serializeWithoutResourcePointcuts() throws IOException {
        File destFile = this.createTempFile();
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(PolicyTestValuesConstants.CONFIG_DATA);
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", POLICY_VERSION, PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList(), 1, policyConfiguration);
        this.policyDefinitionSerializer.serializeToFile(policyDefinition, destFile);
        Assert.assertEquals((Object)IOUtils.getResourceAsString((String)"json/no-resource-pointcuts-definition.json", ((Object)((Object)this)).getClass()).trim(), (Object)FileUtils.readFileToString((File)destFile).trim());
    }

    @Test
    public void serializeWithoutConfigData() throws IOException {
        File destFile = this.createTempFile();
        PolicyDefinition policyDefinition = new PolicyDefinition("policyId", POLICY_VERSION, PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.RESOURCE_POINTCUTS, 1, new PolicyConfiguration(null));
        this.policyDefinitionSerializer.serializeToFile(policyDefinition, destFile);
        Assert.assertEquals((Object)IOUtils.getResourceAsString((String)"json/no-config-data-definition.json", ((Object)((Object)this)).getClass()).trim(), (Object)FileUtils.readFileToString((File)destFile).trim());
    }

    @Test
    public void deserializeFullDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/full-definition.json").getFile());
        PolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeFromFile(file);
        Assert.assertThat((Object)policyDefinition.getName(), (Matcher)Matchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getAssetId() + "-policyId")));
        Assert.assertThat((Object)policyDefinition.getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertEquals((long)1L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertEquals((Object)policyDefinition.getConfigurationData().getConfiguration(), (Object)PolicyTestValuesConstants.CONFIG_DATA);
        Assert.assertEquals((long)2L, (long)policyDefinition.getHttpResourcePointcuts().size());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getPath());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getPath());
        Assert.assertEquals((Object)String.valueOf(policyDefinition.getConfigurationData().getConfiguration().hashCode()), (Object)policyDefinition.getConfigurationData().getConfigurationVersion());
        Assert.assertTrue((boolean)policyDefinition.isOnline());
    }

    @Test
    public void deserializeFullDefinitionNoHash() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/full-definition-no-hash.json").getFile());
        PolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeFromFile(file);
        Assert.assertThat((Object)policyDefinition.getName(), (Matcher)Matchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getAssetId() + "-policyId")));
        Assert.assertThat((Object)policyDefinition.getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertEquals((long)1L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertEquals((Object)policyDefinition.getConfigurationData().getConfiguration(), (Object)PolicyTestValuesConstants.CONFIG_DATA);
        Assert.assertEquals((long)2L, (long)policyDefinition.getHttpResourcePointcuts().size());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getPath());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getPath());
        Assert.assertEquals((Object)String.valueOf(policyDefinition.getConfigurationData().getConfiguration().hashCode()), (Object)policyDefinition.getConfigurationData().getConfigurationVersion());
        Assert.assertTrue((boolean)policyDefinition.isOnline());
    }

    @Test
    public void deserializeFullDefinitionWithHash() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/full-definition-hash.json").getFile());
        PolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeFromFile(file);
        Assert.assertThat((Object)policyDefinition.getName(), (Matcher)Matchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getAssetId() + "-policyId")));
        Assert.assertThat((Object)policyDefinition.getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertEquals((long)1L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertEquals((Object)policyDefinition.getConfigurationData().getConfiguration(), (Object)PolicyTestValuesConstants.CONFIG_DATA);
        Assert.assertEquals((long)2L, (long)policyDefinition.getHttpResourcePointcuts().size());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getPath());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getPath());
        Assert.assertEquals((Object)CONFIG_HASH, (Object)policyDefinition.getConfigurationData().getConfigurationVersion());
        Assert.assertTrue((boolean)policyDefinition.isOnline());
    }

    @Test
    public void deserializeFullDefinitionDifferentIdentation() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/full-definition-different-identation.json").getFile());
        PolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeFromFile(file);
        Assert.assertThat((Object)policyDefinition.getName(), (Matcher)Matchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getAssetId() + "-policyId")));
        Assert.assertThat((Object)policyDefinition.getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertEquals((long)1L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertEquals((Object)policyDefinition.getConfigurationData().getConfiguration(), (Object)PolicyTestValuesConstants.CONFIG_DATA);
        Assert.assertEquals((long)2L, (long)policyDefinition.getHttpResourcePointcuts().size());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(0)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT.getPath());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getMethod(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getMethod());
        Assert.assertEquals((Object)((HttpResourcePointcut)policyDefinition.getHttpResourcePointcuts().get(1)).getPath(), (Object)PolicyTestValuesConstants.RESOURCE_POINTCUT_2.getPath());
        Assert.assertTrue((boolean)policyDefinition.isOnline());
    }

    @Test
    public void deserializeWithoutResourcePointcuts() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/no-resource-pointcuts-definition.json").getFile());
        PolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeFromFile(file);
        Assert.assertThat((Object)policyDefinition.getName(), (Matcher)Matchers.is((Object)(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getAssetId() + "-policyId")));
        Assert.assertThat((Object)policyDefinition.getTemplateKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertEquals((long)1L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertEquals((Object)policyDefinition.getConfigurationData().getConfiguration(), (Object)PolicyTestValuesConstants.CONFIG_DATA);
        Assert.assertTrue((boolean)policyDefinition.getHttpResourcePointcuts().isEmpty());
        Assert.assertTrue((boolean)policyDefinition.isOnline());
    }

    @Test
    public void deserializeOffline() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-single-api-definition.json").getFile());
        OfflinePolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
        Assert.assertEquals((Object)policyDefinition.getName(), (Object)"offline-single-api-definition");
        Assert.assertEquals((long)1L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertTrue((boolean)policyDefinition.getHttpResourcePointcuts().isEmpty());
        Assert.assertFalse((boolean)policyDefinition.isOnline());
    }

    @Test
    public void deserializeOfflineMultipleApis() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-multiple-apis-definition.json").getFile());
        OfflinePolicyDefinition policyDefinition = this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
        Assert.assertEquals((Object)policyDefinition.getName(), (Object)"offline-multiple-apis-definition");
        Assert.assertEquals((long)2L, (long)policyDefinition.getApiKeys().size());
        Assert.assertEquals(policyDefinition.getApiKeys().get(0), (Object)PolicyTestValuesConstants.API_KEY);
        Assert.assertEquals(policyDefinition.getApiKeys().get(1), (Object)PolicyTestValuesConstants.API_KEY_2);
        Assert.assertEquals((Object)policyDefinition.getOrder(), (Object)new Integer(1));
        Assert.assertTrue((boolean)policyDefinition.getHttpResourcePointcuts().isEmpty());
        Assert.assertFalse((boolean)policyDefinition.isOnline());
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeInvalidDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-invalid-field-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeInvalidJson() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-invalid-json.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingApiDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-api-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingOrderDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-order-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeInvalidOrder() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-invalid-order-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingApiIdDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-api-id-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingTemplateDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-template-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingTemplateGroupIdDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-template-group-id-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingTemplateAssetIdDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-template-asset-id-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    @Test(expected=OfflinePolicyDeserializationException.class)
    public void deserializeMissingTemplateVersionDefinition() throws IOException {
        File file = new File(((Object)((Object)this)).getClass().getResource("/json/offline-missing-template-version-definition.json").getFile());
        this.policyDefinitionSerializer.deserializeOfflineFromFile(file);
    }

    private File createTempFile() throws IOException {
        File tempFile = File.createTempFile("pre", "suf");
        tempFile.deleteOnExit();
        return tempFile;
    }
}

