/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.google.common.collect.Lists;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.retry.BackoffRunnableRetrier;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.test.backoff.scheduler.factory.FixedExecutorBackoffSchedulerFactory;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.anypoint.tests.scheduler.ObservableScheduledExecutorService;
import com.mulesoft.anypoint.tests.scheduler.observer.RunnableLoggerObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledExecutorObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledTask;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultMultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultTransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import uk.org.lidalia.slf4jext.Level;

@RunWith(value=MockitoJUnitRunner.class)
public class PolicySetDeploymentServiceTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    private static final String POLICY_ID_FAILING = "policyIdFailing";
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    @Mock
    private PolicySpecification policySpecification;
    @Mock
    private PolicySetDeploymentListener listener;
    @Mock
    private ApplicationPolicyManager policyManager;
    @Mock
    private PolicyFactory policyFactory;
    @Mock
    private ApiService apiService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Api api;
    private PolicyTemplate template;
    private Policy policy1;
    private Policy policy2;
    private PolicyDefinition policyDefinition1;
    private PolicyDefinition policyDefinition2;
    private PolicyConfiguration updatedConfiguration;
    private RunnableRetrier<ApiKey> runnableRetrier;
    private RunnableLoggerObserver executorLogger;
    private MultiplexingPolicyDeploymentService policyDeploymentService;
    private TestLogger logger;
    private PolicyStore policyStore;
    private PolicyTemplateStore policyTemplateStore;
    private PolicyDeploymentTracker policyDeploymentTracker;
    private PolicySetDeploymentService policySetDeploymentService;
    private PolicyDefinition policyDefinitionFailing;
    private PolicyDefinition policyDefinitionRecovered;
    private Policy policyRecovered;

    @Before
    public void setUp() {
        this.logger = TestLoggerFactory.getTestLogger(DefaultPolicySetDeploymentService.class);
        ApiImplementation apiImplementation = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)apiImplementation);
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getName()).thenReturn((Object)"appFlow");
        Mockito.when((Object)apiImplementation.getFlow()).thenReturn((Object)flow);
        Mockito.when((Object)apiImplementation.getArtifactName()).thenReturn((Object)"test-app");
        Mockito.when((Object)apiImplementation.getApiKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        this.apiService = (ApiService)Mockito.mock(ApiService.class);
        Mockito.when((Object)this.apiService.get(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(this.api));
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.executorLogger = new RunnableLoggerObserver();
        this.runnableRetrier = this.runnableRetrier(new GatewayConfiguration());
        this.policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        this.policyTemplateStore = new PolicyTemplateStore();
        this.policyDeploymentService = (MultiplexingPolicyDeploymentService)Mockito.spy((Object)new DefaultMultiplexingPolicyDeploymentService(this.apiService, this.policyDeploymentTracker, (TransactionalPolicyDeploymentService)new DefaultTransactionalPolicyDeploymentService(this.policyDeploymentTracker, this.policyStore, this.policyFactory, (PolicyDeployer)new DefaultPolicyDeployer(this.policyStore, new PolicyNotificationListenerSuppliers(), new PolicyParametrizationFactory()))));
        this.policySetDeploymentService = this.policySetDeploymentService();
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(Collections.emptyMap());
        PolicyConfiguration policyConfiguration2 = new PolicyConfiguration(Collections.emptyMap());
        this.updatedConfiguration = new PolicyConfiguration(Collections.singletonMap("key", "value"));
        this.policyDefinition1 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, policyConfiguration);
        this.policyDefinition2 = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, policyConfiguration2);
        this.policyDefinitionFailing = new PolicyDefinition(POLICY_ID_FAILING, "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, policyConfiguration);
        this.policyDefinitionRecovered = new PolicyDefinition(POLICY_ID_FAILING, "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, PolicyTestValuesConstants.API_KEY, null, 1, policyConfiguration);
        this.template = (PolicyTemplate)Mockito.mock(PolicyTemplate.class);
        Mockito.when((Object)this.template.getKey()).thenReturn((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        this.policy1 = new Policy(this.template, this.policyDefinition1, RESOLVED_TEMPLATE);
        PolicyTemplate policyTemplate2 = new PolicyTemplate(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, (File)Mockito.mock(File.class), this.policySpecification, new PolicyTemplateDescriptor(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        policyTemplate2.getTemplateDescriptor().setMinMuleVersion(new MuleVersion("4.4.0"));
        this.policy2 = new Policy(policyTemplate2, this.policyDefinition2, RESOLVED_TEMPLATE);
        this.policyRecovered = new Policy(policyTemplate2, this.policyDefinitionRecovered, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition1)).thenReturn((Object)this.policy1);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition2)).thenReturn((Object)this.policy2);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinitionFailing)).thenThrow(new Throwable[]{new PolicyTemplateAssetException("Error processing policy template file for " + PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName(), null)});
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinitionRecovered)).thenReturn((Object)this.policyRecovered);
    }

    private DefaultPolicySetDeploymentService policySetDeploymentService() {
        return this.policySetDeploymentService(this.policyDeploymentTracker);
    }

    @Test
    public void newPoliciesInPolicySet() {
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1, this.policyDefinition2}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void onePolicyRemovedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void everyPolicyRemovedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList(), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void onePolicyUpdatedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        PolicyDefinition updatedPolicyDefinition = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 10, this.updatedConfiguration);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition, RESOLVED_TEMPLATE));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1, updatedPolicyDefinition}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).updatePolicy(this.policyDefinition2, updatedPolicyDefinition);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void onePolicyReorderedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        PolicyDefinition updatedPolicyDefinition = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 10, new PolicyConfiguration(Collections.emptyMap()));
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition, RESOLVED_TEMPLATE));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1, updatedPolicyDefinition}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).reorderPolicy(this.policyDefinition2, updatedPolicyDefinition);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void everyPolicyReorderedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        PolicyDefinition updatedPolicyDefinition1 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 10, new PolicyConfiguration(Collections.emptyMap()));
        PolicyDefinition updatedPolicyDefinition2 = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 11, new PolicyConfiguration(Collections.emptyMap()));
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition1)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition1, RESOLVED_TEMPLATE));
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition2)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition2, RESOLVED_TEMPLATE));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{updatedPolicyDefinition1, updatedPolicyDefinition2}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).reorderPolicy(this.policyDefinition1, updatedPolicyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).reorderPolicy(this.policyDefinition2, updatedPolicyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void everyPolicyUpdatedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        PolicyDefinition updatedPolicyDefinition1 = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 10, this.updatedConfiguration);
        PolicyDefinition updatedPolicyDefinition2 = new PolicyDefinition("policyId-2", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 11, this.updatedConfiguration);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition1)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition1, RESOLVED_TEMPLATE));
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition2)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition2, RESOLVED_TEMPLATE));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{updatedPolicyDefinition1, updatedPolicyDefinition2}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).updatePolicy(this.policyDefinition1, updatedPolicyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).updatePolicy(this.policyDefinition2, updatedPolicyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void onePolicyUpdatedAndOneDeletedInPolicySet() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        PolicyDefinition updatedPolicyDefinition = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 10, this.updatedConfiguration);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(updatedPolicyDefinition)).thenReturn((Object)new Policy(this.template, updatedPolicyDefinition, RESOLVED_TEMPLATE));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{updatedPolicyDefinition}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).updatePolicy(this.policyDefinition1, updatedPolicyDefinition);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void removeApi() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        this.policySetDeploymentService.removeAll(PolicyTestValuesConstants.API_KEY);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void removeApiAndReAddIt() {
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition2));
        this.policySetDeploymentService.removeAll(PolicyTestValuesConstants.API_KEY);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void deploymentListenerWhenEveryPolicyIsOk() {
        this.policySetDeploymentService.addPolicyDeploymentListener(this.listener);
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.eq((Object)PolicyTestValuesConstants.API_KEY), (PolicySet)ArgumentMatchers.eq((Object)policySet), (List)ArgumentMatchers.any());
        this.policySetDeploymentService.removeAll(PolicyTestValuesConstants.API_KEY);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPoliciesRemoved(PolicyTestValuesConstants.API_KEY);
    }

    @Test
    public void onRedeploymentStartListenersAreNotNotified() {
        ApiImplementation implementation = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Mockito.when((Object)implementation.getApiKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null);
        this.policySetDeploymentService.addPolicyDeploymentListener(this.listener);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition1));
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        this.policySetDeploymentService.onApiRedeploymentStart(implementation);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPoliciesRemoved(PolicyTestValuesConstants.API_KEY);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void deploymentListenerWhenSomeErrorInPolicy() {
        PolicySet policySet = this.policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition2);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.never())).removePolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.never())).removePolicy(this.policyDefinition2);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void policiesForApiScheduleTask() {
        this.policySetDeploymentService.policiesForApi(PolicyTestValuesConstants.API_KEY, this.policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.policyDeploymentService});
        MatcherAssert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void retryWhenDownloadErrorPolicy() {
        PolicySet policySet = this.policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        this.onDeploySetDeploymentStatus(this.policyDefinition1, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.retryTask(1).run();
        MatcherAssert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)2));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition2);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.times((int)2))).newPolicy(this.policyDefinition1);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.eq((Object)PolicyTestValuesConstants.API_KEY), (PolicySet)ArgumentMatchers.eq((Object)policySet), (List)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void retryWhenFatalErrorOnDeployment() {
        PolicyDeploymentTracker mockTracker = (PolicyDeploymentTracker)Mockito.mock(PolicyDeploymentTracker.class);
        ((PolicyDeploymentTracker)Mockito.doThrow((Throwable[])new Throwable[]{new InternalError()}).doReturn(new ArrayList()).when((Object)mockTracker)).onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY);
        this.policySetDeploymentService = this.policySetDeploymentService(mockTracker);
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        ((PolicyDeploymentTracker)Mockito.verify((Object)mockTracker)).onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.policyDeploymentService});
        this.policySetDeploymentService.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        this.retryTask(1).run();
        ((PolicyDeploymentTracker)Mockito.verify((Object)mockTracker, (VerificationMode)Mockito.times((int)3))).onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void multipleRetriesAreRequiredForDownloadToBeSuccessful() {
        PolicySet policySet = this.policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        IntStream.range(1, 11).forEach(i -> this.retryTask(i).run());
        this.onDeploySetDeploymentStatus(this.policyDefinition1, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.retryTask(11).run();
        MatcherAssert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)12));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.never())).removePolicy(this.policyDefinition2);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition2);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.times((int)12))).newPolicy(this.policyDefinition1);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.eq((Object)PolicyTestValuesConstants.API_KEY), (PolicySet)ArgumentMatchers.eq((Object)policySet), (List)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void differentPoliciesRecoversAtDifferentSpeeds() {
        PolicySet policySet = this.policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        IntStream.range(1, 11).forEach(i -> this.retryTask(i).run());
        this.onDeploySetDeploymentStatus(this.policyDefinition1, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED);
        IntStream.range(11, 21).forEach(i -> this.retryTask(i).run());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
        this.onDeploySetDeploymentStatus(this.policyDefinition2, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS, PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS);
        this.retryTask(21).run();
        MatcherAssert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)22));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.times((int)12))).newPolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.times((int)22))).newPolicy(this.policyDefinition2);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.eq((Object)PolicyTestValuesConstants.API_KEY), (PolicySet)ArgumentMatchers.eq((Object)policySet), (List)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void logWhenSomeTemplateFailsToBeDownloaded() {
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, this.policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED));
        this.setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED, PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED);
        ArrayList<String> policiesNames = new ArrayList<String>();
        policiesNames.add(this.policyDefinition1.getName());
        policiesNames.add(this.policyDefinition2.getName());
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Deploying policies {} from {} to API {}", new Object[]{policiesNames, "Platform", PolicyTestValuesConstants.API_KEY})));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Template download failed for API {} - Policies {}.", new Object[]{PolicyTestValuesConstants.API_KEY, policiesNames})));
    }

    @Test
    public void exceptionOnListenerDoesNotBlockOtherListeners() {
        PolicySetDeploymentListener listener2 = (PolicySetDeploymentListener)Mockito.mock(PolicySetDeploymentListener.class);
        ((PolicySetDeploymentListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.listener)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.any(), (PolicySet)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        ((PolicySetDeploymentListener)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.listener)).onPoliciesRemoved((ApiKey)ArgumentMatchers.any());
        this.policySetDeploymentService.addPolicyDeploymentListener(this.listener);
        this.policySetDeploymentService.addPolicyDeploymentListener(listener2);
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.eq((Object)PolicyTestValuesConstants.API_KEY), (PolicySet)ArgumentMatchers.eq((Object)policySet), (List)ArgumentMatchers.any());
        ((PolicySetDeploymentListener)Mockito.verify((Object)listener2)).onPolicySetDeploymentCompleted((ApiKey)ArgumentMatchers.eq((Object)PolicyTestValuesConstants.API_KEY), (PolicySet)ArgumentMatchers.eq((Object)policySet), (List)ArgumentMatchers.any());
        this.policySetDeploymentService.removeAll(PolicyTestValuesConstants.API_KEY);
        ((PolicySetDeploymentListener)Mockito.verify((Object)this.listener)).onPoliciesRemoved(PolicyTestValuesConstants.API_KEY);
        ((PolicySetDeploymentListener)Mockito.verify((Object)listener2)).onPoliciesRemoved(PolicyTestValuesConstants.API_KEY);
    }

    @Test
    public void conciliatePolicies() {
        this.policyStore.store(this.policyDefinition1);
        this.policySetDeploymentService.conciliatePolicies(PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition2}));
        MatcherAssert.assertThat((Object)this.policyStore.load(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyDefinition)this.policyStore.load().get(0)), (Matcher)Matchers.is((Object)this.policyDefinition2));
    }

    @Test
    public void conciliateUpdatedPolicy() {
        this.policyStore.store(this.policyDefinition1);
        int differentOrder = 15;
        PolicyDefinition policyDefinition1Updated = new PolicyDefinition("policyId", "", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, differentOrder, new PolicyConfiguration(Collections.emptyMap()));
        this.policySetDeploymentService.conciliatePolicies(PolicyTestValuesConstants.API_KEY, (List)Lists.newArrayList((Object[])new PolicyDefinition[]{policyDefinition1Updated}));
        MatcherAssert.assertThat((Object)this.policyStore.load(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyDefinition)this.policyStore.load().get(0)), (Matcher)Matchers.is((Object)policyDefinition1Updated));
    }

    @Test
    public void initApiDeploysOfflineStoredPolicies() throws URISyntaxException, IOException {
        OfflinePolicyDefinition offlinePolicyDefinition = new OfflinePolicyDefinition("offline-single-api-definition", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, null, 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policyStore.store(this.policyDefinition1);
        FileUtils.copyFileToDirectory((File)this.definitionFile(), (File)PolicyFolders.getOfflinePoliciesFolder());
        Api api = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Policy offlinePolicy = new Policy(this.template, (PolicyDefinition)offlinePolicyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition((PolicyDefinition)offlinePolicyDefinition)).thenReturn((Object)offlinePolicy);
        this.policySetDeploymentService.onApiDeploymentSuccess(api);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)offlinePolicyDefinition);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void deployPolicyFailsWhenDownloadingTemplate() {
        PolicyTemplateAssetException exception = new PolicyTemplateAssetException("", (Exception)new RuntimeException());
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition1)).thenThrow(new Throwable[]{exception});
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentSuccess(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void deployPolicyWithMissingTemplateStillStoresPolicy() throws PolicyTemplateResolverException {
        PolicyTemplateResolverException exception = new PolicyTemplateResolverException("", (Exception)new RuntimeException());
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition1)).thenThrow(new Throwable[]{exception});
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), null);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentSuccess(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Matchers.is((Object)false));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.policyManager});
    }

    @Test
    public void deployPolicyThrowingIllegalStateExceptionLogsException() throws PolicyTemplateResolverException {
        IllegalStateException exception = new IllegalStateException("More than one directory under ~/runtimePath/.mule/policy-templates/wrongPolicy/META-INF/maven so pom.xml file for artifact in folder ~/runtimePath/.mule/policy-templates/wrongPolicy could not be found");
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition1)).thenThrow(new Throwable[]{exception});
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1}), PolicySet.PolicySetOrigin.PLATFORM);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        List<String> policiesNames = Arrays.asList(this.policyDefinition1.getName());
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentFailed(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Deploying policies {} from {} to API {}", new Object[]{policiesNames, "Platform", PolicyTestValuesConstants.API_KEY})));
        TestLogger defaultPolicyDeployerLogger = TestLoggerFactory.getTestLogger(DefaultTransactionalPolicyDeploymentService.class);
        MatcherAssert.assertThat((Object)defaultPolicyDeployerLogger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)defaultPolicyDeployerLogger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.ERROR, (Throwable)exception, "Error deploying policy " + policiesNames.get(0) + " to application test-app", new Object[0])));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition1);
    }

    @Test
    public void twoPoliciesOneAppliedOneThrowingIllegalStateExceptionIsNotAppliedAndIsLogged() throws PolicyTemplateResolverException {
        IllegalStateException exception = new IllegalStateException("More than one directory under ~/runtimePath/.mule/policy-templates/wrongPolicy/META-INF/maven so pom.xml file for artifact in folder ~/runtimePath/.mule/policy-templates/wrongPolicy could not be found");
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition1)).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition2)).thenReturn((Object)this.policy2);
        PolicySet policySet = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1, this.policyDefinition2}), PolicySet.PolicySetOrigin.PLATFORM);
        this.policiesForApi(PolicyTestValuesConstants.API_KEY, policySet);
        List<String> policiesNames = Arrays.asList(this.policyDefinition1.getName(), this.policyDefinition2.getName());
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentFailed(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(1)).getLatestPolicyStatus().isDeploymentFailed(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Deploying policies {} from {} to API {}", new Object[]{policiesNames, "Platform", PolicyTestValuesConstants.API_KEY})));
        TestLogger defaultPolicyDeployerLogger = TestLoggerFactory.getTestLogger(DefaultPolicyDeployer.class);
        TestLogger transactionalPolicyDeployerLogger = TestLoggerFactory.getTestLogger(DefaultTransactionalPolicyDeploymentService.class);
        MatcherAssert.assertThat((Object)defaultPolicyDeployerLogger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)transactionalPolicyDeployerLogger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((LoggingEvent)transactionalPolicyDeployerLogger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.ERROR, (Throwable)exception, "Error deploying policy " + policiesNames.get(0) + " to application test-app", new Object[0])));
        MatcherAssert.assertThat((Object)((LoggingEvent)defaultPolicyDeployerLogger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.DEBUG, "Applying policy {} {} to {} in application {}", new Object[]{this.policyDefinition2.getName(), String.format("version %s", this.policyDefinition2.getTemplateKey().getVersion()), this.api, "test-app"})));
        MatcherAssert.assertThat((Object)((LoggingEvent)defaultPolicyDeployerLogger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.INFO, "Applied policy {} {} to {} in application {}", new Object[]{this.policyDefinition2.getName(), String.format("version %s", this.policyDefinition2.getTemplateKey().getVersion()), this.api, "test-app"})));
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition1);
        ((MultiplexingPolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy(this.policyDefinition2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
    }

    @Test
    public void cleanUnusedTemplatesRemovesTemplatesNotBeingReferenced() throws IOException {
        this.policyTemplateStore.storeYaml(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, IOUtils.toInputStream((String)"some-yaml", (Charset)Charset.defaultCharset()));
        this.policyTemplateStore.storeJar(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, IOUtils.toInputStream((String)"some-jar", (Charset)Charset.defaultCharset()));
        this.policyTemplateStore.storeYaml(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, IOUtils.toInputStream((String)"some-yaml", (Charset)Charset.defaultCharset()));
        this.policyTemplateStore.storeJar(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2, IOUtils.toInputStream((String)"some-jar", (Charset)Charset.defaultCharset()));
        PolicyTemplateAssets templateAssets1 = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        PolicyTemplateAssets templateAssets2 = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2);
        FileUtils.writeStringToFile((File)new File(templateAssets1.getTemplateExtractedJarFolder(), "some-file"), (String)"some-content", (Charset)Charset.defaultCharset());
        FileUtils.writeStringToFile((File)new File(templateAssets2.getTemplateExtractedJarFolder(), "some-file"), (String)"some-content", (Charset)Charset.defaultCharset());
        this.policyStore.store(this.policyDefinition1);
        this.policySetDeploymentService.cleanUnusedTemplates();
        List allTemplateAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allTemplateAssets, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((PolicyTemplateAssets)allTemplateAssets.get(0)).getTemplateName(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getName()));
        MatcherAssert.assertThat((Object)((PolicyTemplateAssets)allTemplateAssets.get(0)).getTemplateJarFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PolicyTemplateAssets)allTemplateAssets.get(0)).getTemplateYamlFile().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PolicyTemplateAssets)allTemplateAssets.get(0)).getTemplateExtractedJarFolder().exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)templateAssets2.getTemplateJarFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)templateAssets2.getTemplateYamlFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)templateAssets2.getTemplateExtractedJarFolder().exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void cleanUnusedTemplatesRemovesTemplateWithOnlyJarPresent() throws IOException {
        this.policyTemplateStore.storeJar(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, IOUtils.toInputStream((String)"some-jar", (Charset)Charset.defaultCharset()));
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.writeStringToFile((File)new File(templateAssets.getTemplateExtractedJarFolder(), "some-file"), (String)"some-content", (Charset)Charset.defaultCharset());
        this.policySetDeploymentService.cleanUnusedTemplates();
        List allTemplateAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allTemplateAssets, (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)templateAssets.getTemplateJarFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)templateAssets.getTemplateYamlFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)templateAssets.getTemplateExtractedJarFolder().exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void cleanUnusedTemplatesRemovesTemplateWithOnlyExplodedFolderPresent() throws IOException {
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        FileUtils.writeStringToFile((File)new File(templateAssets.getTemplateExtractedJarFolder(), "some-file"), (String)"some-content", (Charset)Charset.defaultCharset());
        this.policySetDeploymentService.cleanUnusedTemplates();
        List allTemplateAssets = this.policyTemplateStore.getAllTemplateAssets();
        MatcherAssert.assertThat((Object)allTemplateAssets, (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)templateAssets.getTemplateJarFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)templateAssets.getTemplateYamlFile().exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)templateAssets.getTemplateExtractedJarFolder().exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void recoverWithDifferentTemplate() {
        this.policySetDeploymentService.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinitionFailing}), null));
        this.policySetDeploymentService.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinitionRecovered}), null));
        this.retryTask(0).run();
        this.retryTask(1).run();
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.policyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDefinitionDeploymentStatus)((PolicyDeploymentStatus)this.policyDeploymentTracker.policyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getAppliedPolicyStatus().get()).isDeploymentSuccess(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void invalidTemplateReceived() {
        this.policySetDeploymentService.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinitionRecovered}), null));
        this.policySetDeploymentService.policiesForApi(PolicyTestValuesConstants.API_KEY, new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinitionFailing}), null));
        this.retryTask(0).run();
        this.retryTask(1).run();
        MatcherAssert.assertThat((Object)this.policyDeploymentTracker.policyStatuses(PolicyTestValuesConstants.API_KEY).size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((PolicyDefinitionDeploymentStatus)((PolicyDeploymentStatus)this.policyDeploymentTracker.policyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getAppliedPolicyStatus().get()).isDeploymentSuccess(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.policyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Matchers.is((Object)true));
    }

    private DefaultPolicySetDeploymentService policySetDeploymentService(PolicyDeploymentTracker policyDeploymentTracker) {
        return new DefaultPolicySetDeploymentService(this.runnableRetrier, this.policyDeploymentService, policyDeploymentTracker, this.policyStore, this.policyTemplateStore, this.apiService);
    }

    private PolicySet policiesWithStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus policy1Status, PolicyDefinitionDeploymentStatus.DeploymentStatus policy2Status) {
        this.onDeploySetDeploymentStatus(this.policyDefinition1, policy1Status);
        this.onDeploySetDeploymentStatus(this.policyDefinition2, policy2Status);
        this.setFactoryStatus(policy1Status, policy2Status);
        this.policySetDeploymentService.addPolicyDeploymentListener(this.listener);
        return new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{this.policyDefinition1, this.policyDefinition2}), PolicySet.PolicySetOrigin.PLATFORM);
    }

    private void setFactoryStatus(PolicyDefinitionDeploymentStatus.DeploymentStatus policy1Status, PolicyDefinitionDeploymentStatus.DeploymentStatus policy2Status) {
        this.setFactoryStatus(new Pair((Object)this.policyDefinition1, policy1Status.equals((Object)PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED) ? Optional.empty() : Optional.of(this.policy1)), new Pair((Object)this.policyDefinition2, policy2Status.equals((Object)PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED) ? Optional.empty() : Optional.of(this.policy2)));
    }

    private void setFactoryStatus(Pair<PolicyDefinition, Optional<Policy>> ... policies) {
        Mockito.reset((Object[])new PolicyFactory[]{this.policyFactory});
        for (Pair<PolicyDefinition, Optional<Policy>> policy : policies) {
            if (((Optional)policy.getSecond()).isPresent()) {
                Mockito.when((Object)this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policy.getFirst())).thenReturn((Object)((Policy)((Optional)policy.getSecond()).get()));
                continue;
            }
            Mockito.when((Object)this.policyFactory.createFromPolicyDefinition((PolicyDefinition)policy.getFirst())).thenThrow(new Throwable[]{new PolicyTemplateAssetException("Template download failed ;P", new Exception())});
        }
    }

    private void onDeploySetDeploymentStatus(PolicyDefinition policyDefinition, PolicyDefinitionDeploymentStatus.DeploymentStatus deploymentStatus) {
        ((MultiplexingPolicyDeploymentService)Mockito.doAnswer(invocation -> {
            this.policyDeploymentTracker.policyRemoved(PolicyTestValuesConstants.API_KEY, policyDefinition.getId());
            this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, DeploymentStatusTestFactory.policyApplied(policyDefinition, deploymentStatus));
            return null;
        }).when((Object)this.policyDeploymentService)).newPolicy(policyDefinition);
        ((MultiplexingPolicyDeploymentService)Mockito.doAnswer(invocation -> {
            this.policyDeploymentTracker.policyRemoved(PolicyTestValuesConstants.API_KEY, policyDefinition.getId());
            return null;
        }).when((Object)this.policyDeploymentService)).removePolicy(policyDefinition);
    }

    private void policiesForApi(ApiKey apiKey, PolicySet policySet) {
        this.policySetDeploymentService.policiesForApi(apiKey, policySet);
        this.retryTask(0).run();
    }

    private BackoffRunnableRetrier<ApiKey> runnableRetrier(GatewayConfiguration gatewayConfiguration) {
        return new BackoffRunnableRetrier.Builder("policy-deployment-service", gatewayConfiguration.platformClient().getOutagesStatusCodes(), gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).retryUntilNewSchedule().scheduler(this.backoffSchedulerFactory(), BackoffRunnableRetrier.zeroDelayOnScheduling()).build();
    }

    private PolicyDeploymentStatus successfulStatus(PolicyDefinition definition) {
        return new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(definition));
    }

    private BackoffSchedulerFactory backoffSchedulerFactory() {
        return new FixedExecutorBackoffSchedulerFactory((ScheduledExecutorService)new ObservableScheduledExecutorService(new ScheduledExecutorObserver[]{this.executorLogger}));
    }

    private File definitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/offline-single-api-definition.json").toURI());
    }

    private Runnable retryTask(int index) {
        return ((ScheduledTask)this.executorLogger.scheduledTasks().get(index)).runnable();
    }
}

