/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.anypoint.model.policy;

import static java.lang.String.format;
import static java.util.Arrays.asList;

import java.util.Arrays;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;

public class VersionParser {

  private static final List<String> DEFAULT_JAVA_VERSIONS = asList("8", "11");

  public static List<String> parseVersions(String supportedJavaVersions) throws MojoExecutionException {
    if (supportedJavaVersions == null) {
      return DEFAULT_JAVA_VERSIONS;
    }

    String[] versions = supportedJavaVersions.split(",");
    for (String version : versions) {
      if (!version.matches("\\d+")) {
        throw new MojoExecutionException(format("Invalid value for 'supportedJavaVersions': '%s'", version));
      }
    }

    return Arrays.asList(versions);
  }
}

