/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.anypoint.model.policy.definition;

import com.mulesoft.anypoint.model.policy.exchange.Exchange;

/**
 * A wrapper for all the assets of the definition
 */
public class Definition {

  private final Exchange exchange;
  private final DefinitionGcl gcl;
  private final DefMetadata metadata;

  public Definition(Exchange exchange, DefinitionGcl gcl, DefMetadata metadata) {
    this.exchange = exchange;
    this.gcl = gcl;
    this.metadata = metadata;
  }

  public Exchange getExchange() {
    return exchange;
  }

  public DefinitionGcl getGcl() {
    return gcl;
  }

  public DefMetadata getMetadata() {
    return metadata;
  }
}
