/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.anypoint.model.policy.implementation;

import com.mulesoft.anypoint.model.policy.exchange.Exchange;

/**
 * A wrapper for all the assets of the definition
 */
public class Implementation {

  private final Exchange exchange;
  private final ImplementationMetadata metadata;


  public Implementation(Exchange exchange, ImplementationMetadata metadata) {
    this.exchange = exchange;
    this.metadata = metadata;
  }

  public ImplementationMetadata getMetadata() {
    return metadata;
  }

  public Exchange getExchange() {
    return exchange;
  }
}
