/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint;

import com.mulesoft.anypoint.model.policy.VersionParser;
import com.mulesoft.anypoint.model.policy.definition.Definition;
import com.mulesoft.anypoint.model.policy.implementation.Implementation;
import com.mulesoft.anypoint.model.policy.implementation.ImplementationBuilder;
import com.mulesoft.anypoint.model.policy.implementation.MuleArtifact;
import com.mulesoft.anypoint.model.serde.PolicyMapper;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build-asset-files", defaultPhase=LifecyclePhase.COMPILE)
public class BuildAssetFilesMojo
extends AbstractMojo {
    @Parameter(defaultValue="definition/target", property="definitionDirectory", required=true)
    private File definitionDirectory;
    @Parameter(defaultValue="${project.basedir}", property="implementationDirectory", required=true)
    private File implementationDirectory;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.groupId}", property="groupId", required=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId}", property="artifactId", required=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", property="version", required=true)
    private String version;
    @Parameter(defaultValue="${project.name}", property="name", required=true)
    private String name;
    @Parameter(defaultValue="${supportedJavaVersions}", property="supportedJavaVersions")
    private String supportedJavaVersions;
    private PolicyMapper policyMapper = new PolicyMapper();

    public void execute() throws MojoExecutionException {
        Definition def = this.policyMapper.parseDefinitionFiles(this.definitionDirectory);
        MuleArtifact muleArtifact = this.policyMapper.parseMuleArtifact(this.implementationDirectory);
        List<String> javaVersions = VersionParser.parseVersions(this.supportedJavaVersions);
        Implementation impl = new ImplementationBuilder().withDefinition(def).withMuleArtifact(muleArtifact).withGav(this.groupId, this.artifactId, this.version).withName(this.name).withJavaVersions(javaVersions).build();
        this.policyMapper.writeImplementationFiles(this.outputDirectory, impl);
    }
}

