/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.model.policy.implementation;

import com.mulesoft.anypoint.model.policy.definition.Definition;
import com.mulesoft.anypoint.model.policy.exchange.Dependency;
import com.mulesoft.anypoint.model.policy.exchange.Exchange;
import com.mulesoft.anypoint.model.policy.implementation.Implementation;
import com.mulesoft.anypoint.model.policy.implementation.ImplementationMetadata;
import com.mulesoft.anypoint.model.policy.implementation.MuleArtifact;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class ImplementationBuilder {
    public static final String TECHNOLOGY = "mule4";
    public static final String MAIN = null;
    public static final String POSFIX = "-mule";
    private Definition definition;
    private String groupId;
    private String artifactId;
    private String version;
    private String name;
    private MuleArtifact muleArtifact;
    private List<String> supportedJavaVersions;

    public ImplementationBuilder withDefinition(Definition definition) {
        this.definition = definition;
        return this;
    }

    public ImplementationBuilder withGav(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        return this;
    }

    public ImplementationBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ImplementationBuilder withMuleArtifact(MuleArtifact muleArtifact) {
        this.muleArtifact = muleArtifact;
        return this;
    }

    public Implementation build() throws MojoExecutionException {
        this.validateGavMatchesDefinition();
        Exchange exchange = this.buildImplExchange();
        ImplementationMetadata metadata = this.buildMetadata();
        return new Implementation(exchange, metadata);
    }

    private void validateGavMatchesDefinition() throws MojoExecutionException {
        Exchange exchange = this.definition.getExchange();
        if (!this.groupId.equals(exchange.groupId)) {
            throw new MojoExecutionException(String.format("Implementation groupId %s does not match with definition groupId %s.", this.groupId, exchange.groupId));
        }
        if (!this.artifactId.equals(exchange.assetId + POSFIX)) {
            throw new MojoExecutionException(String.format("Implementation artifactId does not match with the pattern <definition-assetId>-mule. Expected: %s%s, Actual: %s.", exchange.assetId, POSFIX, this.artifactId));
        }
    }

    private Exchange buildImplExchange() {
        Exchange defExchange = this.definition.getExchange();
        Dependency exchangeDep = new Dependency(defExchange.groupId, defExchange.assetId, defExchange.version);
        return new Exchange(MAIN, this.groupId, this.artifactId, this.version, this.name, Collections.singletonList(exchangeDep));
    }

    private ImplementationMetadata buildMetadata() {
        return new ImplementationMetadata(this.name, TECHNOLOGY, this.muleArtifact.minMuleVersion, this.supportedJavaVersions);
    }

    public ImplementationBuilder withJavaVersions(List<String> supportedJavaVersions) {
        this.supportedJavaVersions = supportedJavaVersions;
        return this;
    }
}

