/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.model.serde;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.mulesoft.anypoint.model.policy.definition.DefMetadata;
import com.mulesoft.anypoint.model.policy.definition.Definition;
import com.mulesoft.anypoint.model.policy.definition.DefinitionGcl;
import com.mulesoft.anypoint.model.policy.exchange.Exchange;
import com.mulesoft.anypoint.model.policy.implementation.Implementation;
import com.mulesoft.anypoint.model.policy.implementation.ImplementationMetadata;
import com.mulesoft.anypoint.model.policy.implementation.MuleArtifact;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;

public class PolicyMapper {
    private static final String EXCHANGE_JSON = "exchange.json";
    private static final String GCL_YAML = "gcl.yaml";
    private static final String METADATA_YAML = "metadata.yaml";
    private static final String MULE_ARTIFACT = "mule-artifact.json";
    private static final String METADATA_YAML_HEADER = "#%Policy Implementation 1.0\n";
    private final ObjectMapper jsonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public Definition parseDefinitionFiles(File definitionDirectory) throws MojoExecutionException {
        if (!definitionDirectory.exists()) {
            throw new MojoExecutionException("Definition directory does not exist. Directory: " + definitionDirectory.getAbsolutePath());
        }
        Exchange exchange = this.readFile(definitionDirectory, EXCHANGE_JSON, this.jsonMapper, Exchange.class);
        DefinitionGcl gcl = this.readFile(definitionDirectory, GCL_YAML, this.yamlMapper, DefinitionGcl.class);
        DefMetadata metadata = this.readFile(definitionDirectory, METADATA_YAML, this.yamlMapper, DefMetadata.class);
        return new Definition(exchange, gcl, metadata);
    }

    public MuleArtifact parseMuleArtifact(File location) throws MojoExecutionException {
        return this.readFile(location, MULE_ARTIFACT, this.jsonMapper, MuleArtifact.class);
    }

    public void writeImplementationFiles(File outputDirectory, Implementation impl) throws MojoExecutionException {
        this.setupOutputDirectory(outputDirectory);
        this.writeExchange(outputDirectory, impl.getExchange());
        this.writeMetadata(outputDirectory, impl.getMetadata());
    }

    private <E> E readFile(File directory, String name, ObjectMapper mapper, Class<E> clazz) throws MojoExecutionException {
        File file = new File(directory, name);
        if (!file.exists()) {
            throw new MojoExecutionException(String.format("File %s missing from directory %s.", name, directory.getAbsolutePath()));
        }
        try {
            return (E)mapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("File %s could not be parsed.", name), (Exception)e);
        }
    }

    private void writeExchange(File outputDirectory, Exchange exchange) throws MojoExecutionException {
        File file = new File(outputDirectory, EXCHANGE_JSON);
        try {
            this.jsonMapper.writeValue(file, (Object)exchange);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("File %s could not be written.", EXCHANGE_JSON), (Exception)e);
        }
    }

    private void writeMetadata(File outputDirectory, ImplementationMetadata metadata) throws MojoExecutionException {
        try {
            FileWriter writer = new FileWriter(new File(outputDirectory, METADATA_YAML));
            writer.write(METADATA_YAML_HEADER);
            this.yamlMapper.writeValue((Writer)writer, (Object)metadata);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("File %s could not be written.", METADATA_YAML), (Exception)e);
        }
    }

    private void setupOutputDirectory(File outputDirectory) throws MojoExecutionException {
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Error creating output directory: " + outputDirectory.getAbsolutePath());
        }
    }
}

