/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.api.version;

/**
 * Implementors of this API will be able to inspect details of each type of {@link ArtifactVersion available}. Use
 * {@link ArtifactVersion#accept(VersionVisitor)} to apply the visitor pattern over a version.
 *
 * @param <T> return type of the visiting process.
 */
public interface VersionVisitor<T> {

  T visit(Snapshot version);

  T visit(Release version);

  T visit(Monthly version);

  T visit(MonthlySnapshot version);

  T visit(EarlyAccess version);

  T visit(ReleaseCandidate version);

  T visit(UnknownVersion version);
}
