/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.api.version;

/**
 * Factory for creating {@link ArtifactVersion versions}.
 */
public interface ArtifactVersionFactory {

  /**
   * @param version in the format X.Y.Z[-SNAPSHOT || HFx || Jira-x].
   * @return a version.
   */
  ArtifactVersion create(String version);

  /**
   * Creates an {@link ArtifactVersion} with the defined version as parameter.
   *
   * @param major      version.
   * @param minor      version.
   * @param patch      version.
   * @param isSnapshot whether version is snapshot.
   * @return a version.
   */
  ArtifactVersion create(int major, int minor, int patch, boolean isSnapshot);
}
