/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.api.version;

import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionComparator;

class InternalArtifactVersion
implements ArtifactVersion {
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isSnapshot;

    InternalArtifactVersion(String version) {
        try {
            String[] splittedValues = version.split("\\.");
            this.major = Integer.valueOf(splittedValues[0]);
            this.minor = Integer.valueOf(splittedValues[1]);
            this.patch = Integer.valueOf(splittedValues[2].substring(0, 1));
            this.isSnapshot = splittedValues[2].contains("-SNAPSHOT");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s is not a valid ArtifactVersion", version));
        }
    }

    public InternalArtifactVersion(int major, int minor, int patch, boolean isSnapshot) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.isSnapshot = isSnapshot;
    }

    @Override
    public String value() {
        return this.formattedVersion();
    }

    @Override
    public boolean olderThan(ArtifactVersion anotherVersion) {
        return new ArtifactVersionComparator().compare(this, anotherVersion) < 0;
    }

    public String toString() {
        return this.formattedVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalArtifactVersion)) {
            return false;
        }
        InternalArtifactVersion that = (InternalArtifactVersion)o;
        return this.formattedVersion().equals(that.formattedVersion());
    }

    public int hashCode() {
        return this.formattedVersion().hashCode();
    }

    private String formattedVersion() {
        return String.format("%d.%d.%d%s", this.major, this.minor, this.patch, this.isSnapshot ? "-SNAPSHOT" : "");
    }
}

