/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.api.aether;

import com.mulesoft.anypoint.discovery.api.RuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.exception.NoLatestVersionFoundException;
import com.mulesoft.anypoint.discovery.api.exception.VersionDiscoveryException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionComparator;
import com.mulesoft.anypoint.discovery.internal.aether.AetherVersionProvider;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.mule.runtime.api.deployment.meta.Product;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherRuntimeVersionProvider
implements RuntimeVersionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherRuntimeVersionProvider.class);
    protected final List<ArtifactVersion> allVersions;
    protected final ArtifactVersion latest;

    public AetherRuntimeVersionProvider(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> repositories, Product product) throws VersionDiscoveryException {
        try {
            VersionRangeResult versionRange = new AetherVersionProvider(repositorySystem, repositorySystemSession, repositories).findVersions(this.getArtifact(product));
            List<ArtifactVersion> releases = this.releases(versionRange);
            this.allVersions = releases;
            this.allVersions.addAll(this.snapshots(versionRange).stream().filter(snapshot -> !this.isReleased((ArtifactVersion)snapshot, releases)).collect(Collectors.toList()));
            this.allVersions.sort(new ArtifactVersionComparator());
            LOGGER.debug("All available versions are: " + this.allVersions);
            if (this.allVersions.size() <= 0) {
                throw new NoLatestVersionFoundException("No highest version has been found in Nexus, VersionRangeResult is: " + versionRange);
            }
            this.latest = this.allVersions.get(this.allVersions.size() - 1);
            LOGGER.debug("Latest version is: " + this.latest);
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionDiscoveryException("An error occurred while resolving versions for product " + product, e);
        }
    }

    @Override
    public List<ArtifactVersion> all() {
        return this.allVersions;
    }

    @Override
    public ArtifactVersion latest() {
        return this.latest;
    }

    public List<ArtifactVersion> releases(VersionRangeResult versionRange) {
        return this.allVersions(versionRange).filter(version -> !version.value().contains("-SNAPSHOT")).collect(Collectors.toList());
    }

    public List<ArtifactVersion> snapshots(VersionRangeResult versionRange) {
        return this.allVersions(versionRange).filter(version -> version.value().contains("-SNAPSHOT")).collect(Collectors.toList());
    }

    public Stream<ArtifactVersion> allVersions(VersionRangeResult versionRange) {
        return versionRange.getVersions().stream().map(this.toArtifactVersion()).filter(this.greaterThan411()).distinct();
    }

    private Function<Version, ArtifactVersion> toArtifactVersion() {
        return version -> ArtifactVersion.create(version.toString());
    }

    private Predicate<ArtifactVersion> greaterThan411() {
        return version -> !version.olderThan(ArtifactVersion.create("4.1.1"));
    }

    private boolean isReleased(ArtifactVersion snapshot, List<ArtifactVersion> releases) {
        return releases.stream().anyMatch(release -> snapshot.value().startsWith(release.value()));
    }

    private Artifact getArtifact(Product product) {
        switch (product) {
            case MULE_EE: {
                return this.muleEEBom();
            }
            case MULE: {
                return this.muleCEBom();
            }
        }
        return this.muleEEBom();
    }

    private Artifact muleEEBom() {
        return new DefaultArtifact("com.mulesoft.mule.distributions:mule-ee-bom:(0,]");
    }

    private Artifact muleCEBom() {
        return new DefaultArtifact("org.mule.distributions:mule-bom:(0,]");
    }
}

