/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.api.version;

import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionComparator;

class InternalArtifactVersion
implements ArtifactVersion {
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isSnapshot;
    private final String jiraIssue;

    InternalArtifactVersion(String version) {
        try {
            String[] dotSplittedValues = version.split("\\.");
            this.major = Integer.valueOf(dotSplittedValues[0]);
            this.minor = Integer.valueOf(dotSplittedValues[1]);
            this.patch = Integer.valueOf(dotSplittedValues[2].substring(0, 1));
            this.isSnapshot = dotSplittedValues[2].contains("-SNAPSHOT");
            this.jiraIssue = this.setJiraIssue(dotSplittedValues[2]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s is not a valid ArtifactVersion", version));
        }
    }

    public InternalArtifactVersion(int major, int minor, int patch, boolean isSnapshot) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.isSnapshot = isSnapshot;
        this.jiraIssue = "";
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    @Override
    public String value() {
        return this.formattedVersion();
    }

    @Override
    public boolean olderThan(ArtifactVersion anotherVersion) {
        return new ArtifactVersionComparator().compare(this, anotherVersion) < 0;
    }

    @Override
    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public String toString() {
        return this.formattedVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalArtifactVersion)) {
            return false;
        }
        InternalArtifactVersion that = (InternalArtifactVersion)o;
        return this.formattedVersion().equals(that.formattedVersion());
    }

    public int hashCode() {
        return this.formattedVersion().hashCode();
    }

    private String formattedVersion() {
        return String.format("%d.%d.%d%s%s", this.major, this.minor, this.patch, this.jiraIssue, this.isSnapshot ? "-SNAPSHOT" : "");
    }

    private boolean containsIssueNumber(String value) {
        return !value.toUpperCase().equals("-SNAPSHOT");
    }

    private String setJiraIssue(String dotSplittedValue) {
        return this.isSnapshot && this.containsIssueNumber(dotSplittedValue) ? dotSplittedValue.substring(dotSplittedValue.indexOf(45), dotSplittedValue.lastIndexOf(45)) : "";
    }
}

