/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.internal.aether;

import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherVersionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherVersionProvider.class);
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private List<RemoteRepository> repositories;

    public AetherVersionProvider(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> repositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.repositories = repositories;
    }

    public VersionRangeResult findVersions(Artifact artifact) throws VersionRangeResolutionException {
        LOGGER.trace("Looking for artifact " + artifact.getArtifactId() + " deployed in Nexus, query will be done on repositories: " + this.repositories);
        VersionRangeRequest rangeRequest = new VersionRangeRequest(artifact, this.repositories, null);
        VersionRangeResult versionRange = this.repositorySystem.resolveVersionRange(this.repositorySystemSession, rangeRequest);
        LOGGER.trace("Resulted VersionRange: " + versionRange);
        return versionRange;
    }
}

