/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.loader.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.apiquery.DataGraphParser;
import com.mulesoft.apiquery.ServiceSource;
import com.mulesoft.apiquery.ServiceSourceBuilder;
import com.mulesoft.apiquery.ServiceSources;
import com.mulesoft.apiquery.adapter.internal.EngineData;
import com.mulesoft.apiquery.adapter.internal.loader.DataGraphElementLoader;
import com.mulesoft.apiquery.adapter.internal.loader.GatewayPropertiesLoader;
import com.mulesoft.apiquery.adapter.internal.utils.URLExtractorUtils;
import com.mulesoft.apiquery.core.datagraph.ModelService;
import com.mulesoft.apiquery.core.datagraph.model.DataGraph;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Optional;
import org.mule.runtime.core.api.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;
import scala.concurrent.Future;

public class JsonArrayDataGraphElementLoader
implements DataGraphElementLoader {
    private ModelService modelService = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonArrayDataGraphElementLoader.class);
    private static final String JSON_SOURCE_ID_KEY = "sourceId";
    private static final String JSON_SOURCE_NAME_KEY = "sourceName";
    private static final String JSON_SOURCE_GRPC_METADATA = "sourceGrpcMetadata";
    private static final String JSON_ANG_ID_KEY = "id";
    private static final String JSON_SOURCE_CONTENT_KEY = "content";
    private static final String JSON_SOURCE_BASE_URI_KEY = "baseUri";
    private static final String JSON_SOURCE_REFS_KEY = "sourceRefs";

    @Override
    public java.util.List<EngineData> loadProperties(GatewayPropertiesLoader loader) {
        ArrayList<EngineData> result;
        block6: {
            result = new ArrayList<EngineData>();
            try {
                LOGGER.debug("About to load json properties");
                String rawSources = loader.rebuildDataGraph();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(rawSources);
                if (jsonNode.isArray()) {
                    for (JsonNode arrayItem : jsonNode) {
                        String angUrl = arrayItem.get(JSON_ANG_ID_KEY).asText();
                        String content = arrayItem.get(JSON_SOURCE_CONTENT_KEY).toString();
                        if (this.modelService == null) {
                            this.initializeModelService(angUrl);
                        }
                        Future futureDataGraph = DataGraphParser.parse((ModelService)this.modelService, (String)content);
                        ServiceSources serviceSources = this.buildServiceSources(arrayItem.get(JSON_SOURCE_REFS_KEY), loader);
                        result.add(new EngineData((Future<DataGraph>)futureDataGraph, serviceSources));
                    }
                    break block6;
                }
                LOGGER.error("Properties have not json array shape");
                throw new IllegalStateException("Properties have not json array shape");
            }
            catch (IllegalStateException e) {
                LOGGER.error("Illegal State error: {}", (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Unknown error: {}", (Object)e.getMessage());
                throw new IllegalStateException("Could not parse json sources: " + e.getMessage());
            }
        }
        return result;
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    private ServiceSources buildServiceSources(JsonNode sourceRefsNode, GatewayPropertiesLoader loader) {
        ArrayList sourceList = new ArrayList();
        sourceRefsNode.forEach(s -> {
            String sourceId = s.get(JSON_SOURCE_ID_KEY).asText();
            JsonNode sourceNameNode = s.get(JSON_SOURCE_NAME_KEY);
            JsonNode sourceGrpcNode = s.get(JSON_SOURCE_GRPC_METADATA);
            ServiceSource source = ServiceSourceBuilder.create((String)sourceId, (String)s.get(JSON_SOURCE_BASE_URI_KEY).asText(), loader.retrieveSecrets(s.get(JSON_SOURCE_ID_KEY).asText()), (Option)Option.apply((Object)sourceNameNode).flatMap(a -> Option.apply((Object)a.asText())), (Option)Option.apply((Object)sourceGrpcNode).flatMap(a -> Option.apply((Object)new ByteArrayInputStream(Base64.decode((String)a.asText())))));
            LOGGER.info("SourceId: {} BaseUri: {}", (Object)source.sourceId(), (Object)source.getBaseUri());
            LOGGER.info("Secrets size: {}", (Object)source.getSecurityCredentials().size());
            sourceList.add(source);
        });
        return new ServiceSources(JavaConverters.asScalaBuffer(sourceList).toList());
    }

    private void initializeModelService(String urlPattern) {
        Optional<String> baseUri = URLExtractorUtils.extractBaseUriFromAng(urlPattern);
        if (!baseUri.isPresent()) {
            throw new IllegalStateException("Could not extract source base uri from ANG URL");
        }
        this.modelService = ModelService.apply((String)baseUri.get(), (List)List.empty());
    }
}

