/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.loader.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mulesoft.apiquery.adapter.internal.loader.DataGraphProperties;
import com.mulesoft.apiquery.adapter.internal.loader.GatewayPropertiesLoader;
import com.mulesoft.apiquery.adapter.internal.loader.PropertiesRetriever;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubPropertiesLoader
implements GatewayPropertiesLoader {
    private final PropertiesRetriever propertiesRetriever;
    private static final int BUFFER_SIZE = 2048;
    private static final String CHUNK_CONTENT_TYPE_ZIP = "application/zip";
    private static final String CHUNK_ENCODING_BASE64 = "BASE64";
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudHubPropertiesLoader.class);

    public CloudHubPropertiesLoader(PropertiesRetriever propertyRetriever) {
        this.propertiesRetriever = propertyRetriever;
    }

    public byte[] decodeBase64(String input) {
        return BaseEncoding.base64().decode((CharSequence)input);
    }

    public Map<String, Map<String, String>> jsonStringToMap(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (Map)objectMapper.readValue(jsonString, Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error converting json to map", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public String rebuildDataGraph() {
        String dataGraph;
        LOGGER.debug("About to rebuild Source");
        if (this.getNumberOfChunks(DataGraphProperties.ChunkType.DATAGRAPH) < 1) {
            throw new IllegalStateException("DataGraph properties size not found in environment");
        }
        String contentType = this.getDataGraphChunkContentType();
        String chunkEncoding = this.getDataGraphChunkEncoding();
        String encodedDataGraph = this.concatenateChunks(DataGraphProperties.ChunkType.DATAGRAPH);
        if (this.isBase64(chunkEncoding)) {
            LOGGER.debug("Base64 encoding");
            byte[] decodedBytes = this.decodeBase64(encodedDataGraph);
            if (this.isZipped(contentType)) {
                LOGGER.debug("ZIP content type");
                try {
                    dataGraph = new String(this.unzip(decodedBytes), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOGGER.error("Error unzipping sources: {}", (Object)e.getMessage());
                    throw new IllegalStateException("Error unzipping sources");
                }
            } else {
                dataGraph = new String(decodedBytes);
            }
        } else {
            if (this.isZipped(contentType)) {
                LOGGER.error("Base64 encoding not found for zip");
                throw new IllegalStateException("Zip content type must be encoded");
            }
            dataGraph = encodedDataGraph;
        }
        return dataGraph;
    }

    @Override
    public Optional<byte[]> rebuildKeyStore() {
        return this.rebuildStore(DataGraphProperties.ChunkType.KEYSTORE);
    }

    @Override
    public Optional<byte[]> rebuildTrustStore() {
        return this.rebuildStore(DataGraphProperties.ChunkType.TRUSTSTORE);
    }

    @Override
    public Map<String, String> retrieveSecrets(String sourceId) {
        LOGGER.debug("About to retrieve secrets");
        HashMap<String, String> result = new HashMap<String, String>();
        String sourceIdWithoutHyphens = sourceId.replaceAll("-", "");
        Optional<String> sourceCredentialsProps = this.propertiesRetriever.getOptionalProperty("DATAGRAPH_SOURCE_CREDENTIALS");
        if (sourceCredentialsProps.isPresent()) {
            String unzipCredentials;
            try {
                unzipCredentials = new String(this.unzip(this.decodeBase64(sourceCredentialsProps.get())), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOGGER.error("Error unzipping credentials: {}", (Object)e.getMessage());
                throw new IllegalStateException("Error unzipping sources");
            }
            Map<String, Map<String, String>> sourceCredentialsMap = this.jsonStringToMap(unzipCredentials);
            if (sourceCredentialsMap.get(sourceIdWithoutHyphens) != null) {
                return sourceCredentialsMap.get(sourceIdWithoutHyphens);
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public byte[] unzip(byte[] bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getEnvType() {
        return this.propertiesRetriever.getProperty("DATAGRAPH_ENV_TYPE");
    }

    @Override
    public Optional<String> getKeyStorePassword() {
        return this.propertiesRetriever.getOptionalProperty("DATAGRAPH_KEYSTORE_PASSWORD");
    }

    @Override
    public Optional<String> getKeyStoreType() {
        return this.propertiesRetriever.getOptionalProperty("DATAGRAPH_KEYSTORE_TYPE");
    }

    @Override
    public String getMasterOrgId() {
        return this.propertiesRetriever.getProperty("DATAGRAPH_MASTER_ORG_ID");
    }

    @Override
    public Optional<String> getTrustStorePassword() {
        return this.propertiesRetriever.getOptionalProperty("DATAGRAPH_TRUSTSTORE_PASSWORD");
    }

    @Override
    public Optional<String> getTrustStoreType() {
        return this.propertiesRetriever.getOptionalProperty("DATAGRAPH_TRUSTSTORE_TYPE");
    }

    private String concatenateChunks(DataGraphProperties.ChunkType type) {
        StringBuilder result = new StringBuilder();
        int chunks = this.getNumberOfChunks(type);
        for (int i = 0; i < chunks; ++i) {
            String chunk = this.propertiesRetriever.getProperty(type.getItemKey(i));
            if (chunk == null) {
                throw new IllegalStateException(String.format("DataGraph chunk not found in position: %d", i));
            }
            result.append(chunk);
        }
        return result.toString();
    }

    private Optional<byte[]> rebuildStore(DataGraphProperties.ChunkType type) {
        if (this.getNumberOfChunks(type) < 1) {
            return Optional.empty();
        }
        LOGGER.debug("About to rebuild truststore");
        byte[] decodedBytes = this.decodeBase64(this.concatenateChunks(type));
        LOGGER.debug("ZIP content type");
        try {
            return Optional.of(this.unzip(decodedBytes));
        }
        catch (IOException e) {
            LOGGER.error("Error unzipping sources: {}", (Object)e.getMessage());
            throw new IllegalStateException("Error unzipping sources");
        }
    }

    private boolean isBase64(String chunkEncoding) {
        return CHUNK_ENCODING_BASE64.equals(chunkEncoding);
    }

    private boolean isZipped(String chunkContentType) {
        return CHUNK_CONTENT_TYPE_ZIP.equals(chunkContentType);
    }

    private String getDataGraphChunkContentType() {
        return this.propertiesRetriever.getProperty("DATAGRAPH_CONTENT_TYPE");
    }

    private String getDataGraphChunkEncoding() {
        return this.propertiesRetriever.getProperty("DATAGRAPH_CONTENT_ENCODING");
    }

    private int getNumberOfChunks(DataGraphProperties.ChunkType type) {
        String size = this.propertiesRetriever.getProperty(type.getSizeKey());
        if (size == null) {
            size = "0";
        }
        try {
            return Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error transforming expected string size");
            throw new IllegalStateException("Size property not found as integer in environment");
        }
    }
}

