/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal;

import com.google.common.hash.Hashing;
import com.mulesoft.apiquery.adapter.internal.ApiQueryAdapterOperations;
import com.mulesoft.apiquery.adapter.internal.GraphQLEngines;
import com.mulesoft.apiquery.adapter.internal.loader.DataGraphProperties;
import com.mulesoft.apiquery.adapter.internal.loader.GatewayPropertiesLoader;
import com.mulesoft.apiquery.adapter.internal.loader.PropertiesRetriever;
import com.mulesoft.apiquery.adapter.internal.loader.impl.CloudHubPropertiesLoader;
import com.mulesoft.apiquery.adapter.internal.loader.impl.DelegatePropertiesRetriever;
import com.mulesoft.apiquery.adapter.internal.loader.impl.EnvPropertiesRetriever;
import com.mulesoft.apiquery.adapter.internal.loader.impl.FilePropertiesRetriever;
import com.mulesoft.apiquery.adapter.internal.loader.impl.JsonArrayDataGraphElementLoader;
import com.mulesoft.apiquery.adapter.internal.loader.impl.SystemPropertiesRetriever;
import com.mulesoft.apiquery.adapter.internal.metric.MetricsReporter;
import com.mulesoft.apiquery.commons.security.DataGraphPropertiesSigner;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={ApiQueryAdapterOperations.class})
public class ApiQueryAdapterConfiguration
implements Initialisable {
    @Parameter
    private String apifAppVersion;
    @Parameter
    private String clientTimeout;
    @Parameter
    private int clientTimeoutDefault;
    @Parameter
    private String connectionIdleTimeout;
    @Parameter
    private int connectionIdleTimeoutDefault;
    @Parameter
    private String connectionTimeout;
    @Parameter
    private int connectionTimeoutDefault;
    private DataGraphPropertiesSigner dataGraphPropertiesSigner = new DataGraphPropertiesSigner("DATAGRAPH");
    @Parameter
    private String enableMemoryCheck;
    @Parameter
    private boolean enableMemoryCheckDefault;
    @Inject
    private HttpService httpService;
    private String MASTER_KEY_HASH = "999718e91ea949541306fa99df685834d4730ba47d5f07c1eb93d10f003ea0fd";
    @Parameter
    private String maxConnections;
    @Parameter
    private int maxConnectionsDefault;
    @Parameter
    private String memoryThreshold;
    @Parameter
    private float memoryThresholdDefault;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    private PropertiesRetriever propertiesRetriever = new DelegatePropertiesRetriever(new SystemPropertiesRetriever(), new EnvPropertiesRetriever(), new FilePropertiesRetriever(System.getenv("DATAGRAPH_PROPERTIES_LOCATION")));
    private GatewayPropertiesLoader propertiesLoader = new CloudHubPropertiesLoader(this.propertiesRetriever);
    @Parameter
    private String propertiesSignaturePublicKey;
    @Parameter
    private String responseBufferSize;
    @Parameter
    private int responseBufferSizeDefault;
    private GraphQLEngines runtime;
    @Parameter
    private String usePersistentConnections;
    @Parameter
    private boolean usePersistentConnectionsDefault;
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiQueryAdapterConfiguration.class);

    public void initialise() throws InitialisationException {
        LOGGER.info("About to init configuration. Version: {}", (Object)this.getApifAppVersion());
        this.validateDataGraphProperties();
        MetricsReporter metricsReporter = new MetricsReporter(this.notificationDispatcher, this.propertiesLoader.getEnvType(), this.propertiesLoader.getMasterOrgId());
        try {
            HttpClient defaultClient = null;
            if (this.httpService != null) {
                defaultClient = this.httpService.getClientFactory().create(this.getHttpClientConfiguration());
                defaultClient.start();
            }
            JsonArrayDataGraphElementLoader loader = new JsonArrayDataGraphElementLoader(this, this.propertiesLoader, metricsReporter, this.httpService, defaultClient);
            GraphQLEngines engines = new GraphQLEngines(loader);
            engines.loadEngineConfig();
            this.runtime = engines;
        }
        catch (IllegalStateException e) {
            LOGGER.error("Error at loading properties: {}", (Object)e.getMessage());
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        catch (Exception e) {
            LOGGER.error("Unknown error at initialisation : {}", (Object)e.getMessage());
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public String getApifAppVersion() {
        return this.apifAppVersion;
    }

    public int getClientTimeout() {
        return this.propertiesRetriever.getInteger(this.clientTimeout, this.clientTimeoutDefault);
    }

    public int getConnectionIdleTimeout() {
        return this.propertiesRetriever.getInteger(this.connectionIdleTimeout, this.connectionIdleTimeoutDefault);
    }

    public int getConnectionTimeout() {
        return this.propertiesRetriever.getInteger(this.connectionTimeout, this.connectionTimeoutDefault);
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public boolean isEnableMemoryCheck() {
        return this.propertiesRetriever.getBoolean(this.enableMemoryCheck, this.enableMemoryCheckDefault);
    }

    public int getMaxConnections() {
        return this.propertiesRetriever.getInteger(this.maxConnections, this.maxConnectionsDefault);
    }

    public float getMemoryThreshold() {
        return this.propertiesRetriever.getFloat(this.memoryThreshold, Float.valueOf(this.memoryThresholdDefault));
    }

    public void setPropertiesLoader(GatewayPropertiesLoader propertiesLoader) {
        this.propertiesLoader = propertiesLoader;
    }

    public int getResponseBufferSize() {
        return this.propertiesRetriever.getInteger(this.responseBufferSize, this.responseBufferSizeDefault);
    }

    public GraphQLEngines getRuntime() {
        return this.runtime;
    }

    public boolean isUsePersistentConnections() {
        return this.propertiesRetriever.getBoolean(this.usePersistentConnections, this.usePersistentConnectionsDefault);
    }

    private boolean masterKeyUsed() {
        return Hashing.sha256().hashString((CharSequence)this.propertiesRetriever.getOptionalProperty("DATAGRAPH_PROPERTIES_SIGNATURE").orElse(""), StandardCharsets.UTF_8).toString().equals(this.MASTER_KEY_HASH);
    }

    private void validateDataGraphProperties() throws InitialisationException {
        Map<String, String> allProperties = this.propertiesRetriever.getAllProperties();
        if (!this.dataGraphPropertiesSigner.verifySignatureForDataGraphProperties(this.propertiesSignaturePublicKey, allProperties) && !this.masterKeyUsed()) {
            String message = "Invalid signature for DataGraph properties";
            LOGGER.error(message);
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)message), (Initialisable)this);
        }
        LOGGER.info("Signature for DataGraph properties is valid");
        ArrayList<String> missingProperties = new ArrayList<String>();
        for (String property : DataGraphProperties.REQUIRED_PROPERTIES) {
            if (allProperties.containsKey(property)) continue;
            missingProperties.add(property);
        }
        if (!missingProperties.isEmpty()) {
            String message = "Missing required properties: " + Arrays.toString(missingProperties.toArray());
            LOGGER.error(message);
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)message), (Initialisable)this);
        }
    }

    private HttpClientConfiguration getHttpClientConfiguration() {
        return new HttpClientConfiguration.Builder().setName("ApiFederation").setUsePersistentConnections(this.isUsePersistentConnections()).setMaxConnections(this.getMaxConnections()).setConnectionIdleTimeout(this.getConnectionIdleTimeout()).setResponseBufferSize(this.getResponseBufferSize()).setClientSocketProperties(TcpClientSocketProperties.builder().clientTimeout(Integer.valueOf(this.getClientTimeout())).connectionTimeout(Integer.valueOf(this.getConnectionTimeout())).build()).build();
    }
}

