/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.loader.impl;

import com.mulesoft.apiquery.adapter.internal.loader.PropertiesRetriever;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePropertiesRetriever
extends PropertiesRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePropertiesRetriever.class);
    private final Properties properties = new Properties();

    public FilePropertiesRetriever(String file) {
        if (file != null) {
            try (FileInputStream resource = new FileInputStream(file);){
                this.properties.load(resource);
            }
            catch (IOException e) {
                LOGGER.warn("Can not load resource '" + file + "'", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> getAllProperties() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }
}

