/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.metric;

import com.mulesoft.apiquery.adapter.internal.metric.ActionType;
import com.mulesoft.apiquery.adapter.internal.metric.MetricBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.notification.CustomNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReporter {
    protected NotificationDispatcher notificationDispatcher;
    private final String envType;
    private final String masterOrgId;
    private static final int EVENT_ACTION_ID = 703591261;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsReporter.class);

    public MetricsReporter(NotificationDispatcher notificationDispatcher, String envType, String masterOrgId) {
        this.notificationDispatcher = notificationDispatcher;
        this.envType = envType;
        this.masterOrgId = masterOrgId;
    }

    public void report(String sourceKey, ActionType action, String apifAppVersion, List<MetricBuilder.Dimension> dimensions, List<MetricBuilder.Fact> facts, Optional<String> sourceName) {
        if (this.notificationDispatcher == null) {
            LOGGER.error("notificationDispatcher not set for Metric reporter");
            return;
        }
        String sourceId = sourceKey == null ? "unknown_source" : sourceKey;
        MetricBuilder builder = new MetricBuilder().withName("api_federation_outbound").withDimension(MetricBuilder.Dimension.build("sourceId", sourceId)).withDimension(MetricBuilder.Dimension.build("action", action.name())).withDimension(MetricBuilder.Dimension.build("apifAppVersion", apifAppVersion));
        MetricBuilder customerBuilder = new MetricBuilder().withName("user_federation_metrics").withDimension(MetricBuilder.Dimension.build("action", action.name()));
        builder.withDimension(MetricBuilder.Dimension.build("envType", this.envType));
        customerBuilder.withDimension(MetricBuilder.Dimension.build("envType", this.envType));
        builder.withDimension(MetricBuilder.Dimension.build("masterOrgId", this.masterOrgId));
        customerBuilder.withDimension(MetricBuilder.Dimension.build("masterOrgId", this.masterOrgId));
        sourceName.ifPresent(name -> builder.withDimension(MetricBuilder.Dimension.build("sourceName", name)));
        sourceName.ifPresent(name -> customerBuilder.withDimension(MetricBuilder.Dimension.build("sourceName", name)));
        dimensions.forEach(customerBuilder::withDimension);
        facts.forEach(customerBuilder::withFact);
        dimensions.forEach(builder::withDimension);
        facts.forEach(builder::withFact);
        Map<String, Object> metric = builder.build();
        Map<String, Object> customerMetrics = customerBuilder.build();
        this.notificationDispatcher.dispatch((Notification)new CustomNotification(metric, 703591261));
        this.notificationDispatcher.dispatch((Notification)new CustomNotification(customerMetrics, 703591261));
    }
}

