/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal;

import com.mulesoft.apiquery.adapter.internal.ApiQueryAdapterConfiguration;
import com.mulesoft.apiquery.adapter.internal.JsonOutputStaticTypeResolver;
import com.mulesoft.apiquery.graphql.GraphQLService;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class ApiQueryAdapterOperations {
    public static final String CACHE_CONTROL_VAR = "cacheControl";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiQueryAdapterOperations.class);

    @MediaType(value="text/plain")
    public void definition(@Config ApiQueryAdapterConfiguration config, @Content(primary=true) @Optional String sourceKey, String requestId, String correlationId, Map<String, String> headers, Map<String, String> queryParams, CompletionCallback<String, Void> callback) {
        try {
            LOGGER.debug("About to execute DEFINITION operation");
            this.executeAsyncDefinition(config.getRuntime().definition(sourceKey, headers, queryParams, requestId, correlationId), callback);
        }
        catch (Exception e) {
            LOGGER.error("Unknown error on DEFINITION operation: {}", (Object)e.getMessage());
            callback.error((Throwable)e);
        }
    }

    @OutputResolver(output=JsonOutputStaticTypeResolver.class)
    public void execute(@Config ApiQueryAdapterConfiguration config, @Optional String query, @Optional String sourceKey, String requestId, String correlationId, @Optional String operation, Map<String, Object> variables, Map<String, String> headers, Map<String, String> queryParams, Map<String, Object> extensions, CompletionCallback<Map<String, Object>, Map<String, String>> callback) {
        try {
            CompletionStage<GraphQLService.GraphQLServiceResult> execution = config.getRuntime().execute(query, operation, sourceKey, variables, headers, queryParams, requestId, correlationId, extensions);
            this.executeAsync(execution, callback);
        }
        catch (Exception e) {
            LOGGER.error("Unknown error on EXECUTE operation: {}", (Object)e.getMessage());
            callback.error((Throwable)e);
        }
    }

    private void executeAsync(CompletionStage<GraphQLService.GraphQLServiceResult> execution, CompletionCallback<Map<String, Object>, Map<String, String>> callback) {
        execution.handle((r, ex) -> {
            if (ex == null) {
                return Either.right((Object)r);
            }
            return Either.left((Object)ex);
        }).thenAccept(resultEither -> {
            try {
                if (resultEither.isRight()) {
                    GraphQLService.GraphQLServiceResult graphQlResult = (GraphQLService.GraphQLServiceResult)resultEither.getRight();
                    Map<String, String> responseHeaders = OptionConverters.toJava((Option)graphQlResult.resultingCacheControl()).map(value -> Collections.singletonMap(CACHE_CONTROL_VAR, value)).orElse(Collections.emptyMap());
                    callback.success(ApiQueryAdapterOperations.success(graphQlResult.specificationValue(), responseHeaders));
                } else {
                    callback.error((Throwable)resultEither.getLeft());
                }
            }
            catch (Throwable e) {
                callback.error(e);
            }
        });
    }

    private void executeAsyncDefinition(CompletionStage<String> execution, CompletionCallback<String, Void> callback) {
        execution.handle((r, ex) -> {
            if (ex == null) {
                return Either.right((Object)r);
            }
            return Either.left((Object)ex);
        }).thenAccept(result -> {
            if (result.isRight()) {
                callback.success(ApiQueryAdapterOperations.successDefinition((String)result.getRight()));
            } else {
                callback.error((Throwable)result.getLeft());
            }
        });
    }

    private static Result<Map<String, Object>, Map<String, String>> success(Map<String, Object> val, Map<String, String> attributes) {
        return Result.builder().output(val).attributes(attributes).build();
    }

    private static Result<String, Void> successDefinition(String val) {
        return Result.builder().output((Object)val).build();
    }
}

