/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.metric;

import java.util.HashMap;
import java.util.Map;

public class MetricBuilder {
    private final Map<String, Object> dimensions = new HashMap<String, Object>();
    private final Map<String, Double> facts = new HashMap<String, Double>();
    private final Map<String, Object> metric = new HashMap<String, Object>();
    private static final String METRIC_NAME = "metric_name";
    private static final String DIMENSIONS_METRIC = "dimensions";
    private static final String FACTS_METRIC = "facts";
    private static final String VALUE = "value";
    private static final String COLLAPSIBLE = "collapsible";

    public MetricBuilder() {
        this.metric.put(DIMENSIONS_METRIC, this.dimensions);
        this.metric.put(FACTS_METRIC, this.facts);
    }

    public Map<String, Object> build() {
        return this.metric;
    }

    public MetricBuilder withDimension(Dimension dimension) {
        HashMap<String, Object> dimensionMap = new HashMap<String, Object>();
        dimensionMap.put(VALUE, dimension.getValue());
        dimensionMap.put(COLLAPSIBLE, dimension.getCollapsible());
        this.dimensions.put(dimension.getDimensionName(), dimensionMap);
        return this;
    }

    public MetricBuilder withFact(Fact fact) {
        this.facts.put(fact.getFactName(), fact.getValue());
        return this;
    }

    public MetricBuilder withName(String name) {
        this.metric.put(METRIC_NAME, name);
        return this;
    }

    public static class Fact {
        private String factName;
        private Double value;

        public String getFactName() {
            return this.factName;
        }

        public void setFactName(String factName) {
            this.factName = factName;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public static Fact build(String name, Double value) {
            Fact fact = new Fact();
            fact.setFactName(name);
            fact.setValue(value);
            return fact;
        }
    }

    public static class Dimension {
        private boolean collapsible = false;
        private String dimensionName;
        private String value;

        public boolean getCollapsible() {
            return this.collapsible;
        }

        public void setCollapsible(boolean collapsible) {
            this.collapsible = collapsible;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static Dimension build(String name, String value) {
            Dimension dimension = new Dimension();
            dimension.setDimensionName(name);
            dimension.setValue(value);
            return dimension;
        }
    }
}

