/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.http;

import com.mulesoft.apiquery.ServiceSource;
import com.mulesoft.apiquery.adapter.internal.http.Throttling;
import com.mulesoft.apiquery.adapter.internal.metric.ActionType;
import com.mulesoft.apiquery.adapter.internal.metric.Chronometer;
import com.mulesoft.apiquery.adapter.internal.metric.MetricBuilder;
import com.mulesoft.apiquery.adapter.internal.metric.MetricsReporter;
import com.mulesoft.apiquery.http.HTTPProtocolClient;
import com.mulesoft.apiquery.http.request.HttpRequest;
import com.mulesoft.apiquery.log.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class MuleHttpClient
extends HTTPProtocolClient {
    private final String apifAppVersion;
    private final HttpClient httpClient;
    private final HttpRequestOptions httpClientConfig;
    private final MetricsReporter metricsReporter;
    private final Throttling throttling;
    private static final Logger LOG = LoggerFactory.getLogger(MuleHttpClient.class);

    public MuleHttpClient(HttpClient httpClient, MetricsReporter metricsReporter, Throttling throttling, String apifAppVersion, HttpRequestOptions httpClientConfig) {
        this.httpClient = httpClient;
        this.metricsReporter = metricsReporter;
        this.throttling = throttling;
        this.apifAppVersion = apifAppVersion;
        this.httpClientConfig = httpClientConfig;
    }

    public Future<com.mulesoft.apiquery.http.response.HttpResponse<String>> execute(HttpRequest request, ServiceSource source, Logging.LogContext lc) {
        CompletionStage futureResponse;
        Chronometer chronometer = Chronometer.create().start();
        try {
            futureResponse = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.throttling.beforeInvoke(request).orElseGet(() -> this.httpClient.sendAsync(this.adapt(request), this.httpClientConfig)).thenApply(this::adapt)).thenApply(r -> {
                this.throttling.afterInvoke(request);
                return r;
            })).thenApply(r -> this.reportMetrics((com.mulesoft.apiquery.http.response.HttpResponse<String>)r, source, chronometer, this.apifAppVersion))).whenComplete((r, e) -> {
                if (e != null) {
                    this.throttling.afterInvoke(request);
                }
            });
        }
        catch (Exception e2) {
            LOG.error("Unexpected MuleHttpClient execute exception: {}", (Object)e2.getMessage());
            this.throttling.afterInvoke(request);
            futureResponse = new CompletableFuture();
            futureResponse.completeExceptionally(e2);
        }
        return FutureConverters.toScala(futureResponse);
    }

    private com.mulesoft.apiquery.http.response.HttpResponse<String> adapt(HttpResponse response) {
        try {
            String content = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return com.mulesoft.apiquery.http.response.HttpResponse.create((int)response.getStatusCode(), (Option)Option.apply((Object)content), (java.util.Map)response.getHeaders(), (int)content.length());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private org.mule.runtime.http.api.domain.message.request.HttpRequest adapt(HttpRequest request) {
        HttpRequestBuilder reqBuilder = (HttpRequestBuilder)((HttpRequestBuilder)org.mule.runtime.http.api.domain.message.request.HttpRequest.builder().method(request.method().toUpperCase()).uri(String.format("%s://%s", request.protocol(), request.url())).headers(new MultiMap(JavaConverters.mapAsJavaMap((Map)request.headers())))).addHeaders("Accept", JavaConverters.asJavaCollection((Iterable)request.mediaTypes()));
        if (request.payload().nonEmpty()) {
            reqBuilder.entity((HttpEntity)new ByteArrayHttpEntity(((String)request.payload().get()).getBytes(StandardCharsets.UTF_8)));
        }
        return reqBuilder.build();
    }

    private com.mulesoft.apiquery.http.response.HttpResponse<String> reportMetrics(com.mulesoft.apiquery.http.response.HttpResponse<String> response, ServiceSource source, Chronometer chronometer, String apifAppVersion) {
        if (this.metricsReporter == null) {
            return response;
        }
        MetricBuilder.Dimension responseCodeFact = MetricBuilder.Dimension.build("http_status", Integer.toString(response.status()));
        MetricBuilder.Fact requestCount = MetricBuilder.Fact.build("request_count", 1.0);
        MetricBuilder.Fact timeFact = MetricBuilder.Fact.build("time", Double.valueOf(chronometer.getMilliseconds()));
        MetricBuilder.Fact payloadSizeFact = MetricBuilder.Fact.build("payload_size", Double.valueOf(response.getLength()));
        Optional<String> sourceName = source != null && source.getSourceName().isDefined() ? Optional.ofNullable(source.getSourceName().get()) : Optional.empty();
        String sourceId = source == null ? "unknown_source" : source.getSourceId();
        List<MetricBuilder.Fact> facts = Arrays.asList(requestCount, timeFact, payloadSizeFact);
        this.metricsReporter.report(sourceId, ActionType.EXECUTE, apifAppVersion, Collections.singletonList(responseCodeFact), facts, sourceName);
        return response;
    }
}

