/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.loader.impl;

import com.mulesoft.apiquery.adapter.internal.loader.PropertiesRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePropertiesRetriever
extends PropertiesRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePropertiesRetriever.class);
    private final Properties properties = new Properties();

    public FilePropertiesRetriever(String file) {
        if (file != null) {
            try (InputStream resource = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);){
                this.properties.load(resource);
            }
            catch (IOException e) {
                LOGGER.warn("Can not load resource '" + file + "'", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> getAllProperties() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }
}

