/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Zip {
    private ZipFile zipFile;
    private static final int BUFFER_SIZE = 8192;

    public Zip(String zipFile) throws IOException {
        this.zipFile = new ZipFile(zipFile);
    }

    public String getContentFile(String name) throws IOException {
        String line;
        InputStream file = this.getFile(name);
        BufferedReader br = new BufferedReader(new InputStreamReader(file));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void extractAll(String path) throws IOException {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String filePath = path + zipEntry.getName();
            if (!zipEntry.isDirectory()) {
                File newFile = new File(filePath);
                this.extract(path, zipEntry.getName());
                continue;
            }
            File dir = new File(filePath);
            dir.mkdir();
        }
    }

    private void extract(String path, String name) throws IOException {
        InputStream is = this.getFile(name);
        FileOutputStream fos = null;
        try {
            int length;
            fos = new FileOutputStream(path + name);
            byte[] buf = new byte[8192];
            boolean read = false;
            while ((length = is.read(buf, 0, buf.length)) >= 0) {
                fos.write(buf, 0, length);
            }
        }
        catch (IOException ioex) {
            ((FileOutputStream)Objects.requireNonNull(fos)).close();
        }
    }

    private InputStream getFile(String name) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(name);
        return this.zipFile.getInputStream(entry);
    }
}

